/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.javassist.runtime;

public class Desc {
    public static boolean useContextClassLoader = false;

    private static Class getClassObject(String name) throws ClassNotFoundException {
        if (useContextClassLoader) {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        return Class.forName(name);
    }

    public static Class getClazz(String name) {
        try {
            return Desc.getClassObject(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("$class: internal error, could not find class '" + name + "' (Desc.useContextClassLoader: " + Boolean.toString(useContextClassLoader) + ")", e);
        }
    }

    public static Class[] getParams(String desc) {
        if (desc.charAt(0) != '(') {
            throw new RuntimeException("$sig: internal error");
        }
        return Desc.getType(desc, desc.length(), 1, 0);
    }

    public static Class getType(String desc) {
        Class[] result2 = Desc.getType(desc, desc.length(), 0, 0);
        if (result2 == null || result2.length != 1) {
            throw new RuntimeException("$type: internal error");
        }
        return result2[0];
    }

    private static Class[] getType(String desc, int descLen, int start2, int num) {
        Class<Object> clazz;
        if (start2 >= descLen) {
            return new Class[num];
        }
        char c = desc.charAt(start2);
        switch (c) {
            case 'Z': {
                clazz = Boolean.TYPE;
                break;
            }
            case 'C': {
                clazz = Character.TYPE;
                break;
            }
            case 'B': {
                clazz = Byte.TYPE;
                break;
            }
            case 'S': {
                clazz = Short.TYPE;
                break;
            }
            case 'I': {
                clazz = Integer.TYPE;
                break;
            }
            case 'J': {
                clazz = Long.TYPE;
                break;
            }
            case 'F': {
                clazz = Float.TYPE;
                break;
            }
            case 'D': {
                clazz = Double.TYPE;
                break;
            }
            case 'V': {
                clazz = Void.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                return Desc.getClassType(desc, descLen, start2, num);
            }
            default: {
                return new Class[num];
            }
        }
        Class[] result2 = Desc.getType(desc, descLen, start2 + 1, num + 1);
        result2[num] = clazz;
        return result2;
    }

    private static Class[] getClassType(String desc, int descLen, int start2, int num) {
        int end = start2;
        while (desc.charAt(end) == '[') {
            ++end;
        }
        if (desc.charAt(end) == 'L' && (end = desc.indexOf(59, end)) < 0) {
            throw new IndexOutOfBoundsException("bad descriptor");
        }
        String cname = desc.charAt(start2) == 'L' ? desc.substring(start2 + 1, end) : desc.substring(start2, end + 1);
        Class[] result2 = Desc.getType(desc, descLen, end + 1, num + 1);
        try {
            result2[num] = Desc.getClassObject(cname.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        return result2;
    }
}

