/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.net.jpountz.xxhash;

import com.alibaba.schedulerx.shade.net.jpountz.util.ByteBufferUtils;
import com.alibaba.schedulerx.shade.net.jpountz.util.SafeUtils;
import com.alibaba.schedulerx.shade.net.jpountz.xxhash.XXHash64;
import com.alibaba.schedulerx.shade.net.jpountz.xxhash.XXHashFactory;
import com.alibaba.schedulerx.shade.net.jpountz.xxhash.XXHashJNI;
import java.nio.ByteBuffer;

final class XXHash64JNI
extends XXHash64 {
    public static final XXHash64 INSTANCE = new XXHash64JNI();
    private static XXHash64 SAFE_INSTANCE;

    XXHash64JNI() {
    }

    @Override
    public long hash(byte[] buf, int off, int len2, long seed) {
        SafeUtils.checkRange(buf, off, len2);
        return XXHashJNI.XXH64(buf, off, len2, seed);
    }

    @Override
    public long hash(ByteBuffer buf, int off, int len2, long seed) {
        if (buf.isDirect()) {
            ByteBufferUtils.checkRange(buf, off, len2);
            return XXHashJNI.XXH64BB(buf, off, len2, seed);
        }
        if (buf.hasArray()) {
            return this.hash(buf.array(), off, len2, seed);
        }
        XXHash64 safeInstance = SAFE_INSTANCE;
        if (safeInstance == null) {
            safeInstance = SAFE_INSTANCE = XXHashFactory.safeInstance().hash64();
        }
        return safeInstance.hash(buf, off, len2, seed);
    }
}

