/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.net.sf.json;

import com.alibaba.schedulerx.shade.net.sf.ezmorph.Morpher;
import com.alibaba.schedulerx.shade.net.sf.ezmorph.object.IdentityObjectMorpher;
import com.alibaba.schedulerx.shade.net.sf.json.AbstractJSON;
import com.alibaba.schedulerx.shade.net.sf.json.JSON;
import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONFunction;
import com.alibaba.schedulerx.shade.net.sf.json.JSONNull;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import com.alibaba.schedulerx.shade.net.sf.json.JSONSerializer;
import com.alibaba.schedulerx.shade.net.sf.json.JSONString;
import com.alibaba.schedulerx.shade.net.sf.json.JsonConfig;
import com.alibaba.schedulerx.shade.net.sf.json.processors.JsonValueProcessor;
import com.alibaba.schedulerx.shade.net.sf.json.processors.JsonVerifier;
import com.alibaba.schedulerx.shade.net.sf.json.util.JSONTokener;
import com.alibaba.schedulerx.shade.net.sf.json.util.JSONUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class JSONArray
extends AbstractJSON
implements JSON,
List,
Comparable {
    private List elements = new ArrayList();
    private boolean expandElements;

    public static JSONArray fromObject(Object object) {
        return JSONArray.fromObject(object, new JsonConfig());
    }

    public static JSONArray fromObject(Object object, JsonConfig jsonConfig) {
        if (object instanceof JSONString) {
            return JSONArray._fromJSONString((JSONString)object, jsonConfig);
        }
        if (object instanceof JSONArray) {
            return JSONArray._fromJSONArray((JSONArray)object, jsonConfig);
        }
        if (object instanceof Collection) {
            return JSONArray._fromCollection((Collection)object, jsonConfig);
        }
        if (object instanceof JSONTokener) {
            return JSONArray._fromJSONTokener((JSONTokener)object, jsonConfig);
        }
        if (object instanceof String) {
            return JSONArray._fromString((String)object, jsonConfig);
        }
        if (object != null && object.getClass().isArray()) {
            Class<?> type = object.getClass().getComponentType();
            if (!type.isPrimitive()) {
                return JSONArray._fromArray((Object[])object, jsonConfig);
            }
            if (type == Boolean.TYPE) {
                return JSONArray._fromArray((boolean[])object, jsonConfig);
            }
            if (type == Byte.TYPE) {
                return JSONArray._fromArray((byte[])object, jsonConfig);
            }
            if (type == Short.TYPE) {
                return JSONArray._fromArray((short[])object, jsonConfig);
            }
            if (type == Integer.TYPE) {
                return JSONArray._fromArray((int[])object, jsonConfig);
            }
            if (type == Long.TYPE) {
                return JSONArray._fromArray((long[])object, jsonConfig);
            }
            if (type == Float.TYPE) {
                return JSONArray._fromArray((float[])object, jsonConfig);
            }
            if (type == Double.TYPE) {
                return JSONArray._fromArray((double[])object, jsonConfig);
            }
            if (type == Character.TYPE) {
                return JSONArray._fromArray((char[])object, jsonConfig);
            }
            throw new JSONException("Unsupported type");
        }
        if (JSONUtils.isBoolean(object) || JSONUtils.isFunction(object) || JSONUtils.isNumber(object) || JSONUtils.isNull(object) || JSONUtils.isString(object) || object instanceof JSON) {
            JSONArray.fireArrayStartEvent(jsonConfig);
            JSONArray jsonArray2 = new JSONArray().element(object, jsonConfig);
            JSONArray.fireElementAddedEvent(0, jsonArray2.get(0), jsonConfig);
            JSONArray.fireArrayStartEvent(jsonConfig);
            return jsonArray2;
        }
        if (object instanceof Enum) {
            return JSONArray._fromArray((Enum)object, jsonConfig);
        }
        if (object instanceof Annotation || object != null && object.getClass().isAnnotation()) {
            throw new JSONException("Unsupported type");
        }
        if (JSONUtils.isObject(object)) {
            JSONArray.fireArrayStartEvent(jsonConfig);
            JSONArray jsonArray3 = new JSONArray().element(JSONObject.fromObject(object, jsonConfig));
            JSONArray.fireElementAddedEvent(0, jsonArray3.get(0), jsonConfig);
            JSONArray.fireArrayStartEvent(jsonConfig);
            return jsonArray3;
        }
        throw new JSONException("Unsupported type");
    }

    public static Class[] getCollectionType(PropertyDescriptor pd, boolean useGetter) throws JSONException {
        Type type;
        Method m;
        if (useGetter) {
            m = pd.getReadMethod();
            type = m.getGenericReturnType();
        } else {
            m = pd.getWriteMethod();
            Type[] gpts = m.getGenericParameterTypes();
            if (1 != gpts.length) {
                throw new JSONException("method " + m + " is not a standard setter");
            }
            type = gpts[0];
        }
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pType = (ParameterizedType)type;
        Type[] actualTypes = pType.getActualTypeArguments();
        Class[] ret = new Class[actualTypes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Class)actualTypes[i];
        }
        return ret;
    }

    public static int[] getDimensions(JSONArray jsonArray2) {
        if (jsonArray2 == null || jsonArray2.isEmpty()) {
            return new int[]{0};
        }
        ArrayList dims = new ArrayList();
        JSONArray.processArrayDimensions(jsonArray2, dims, 0);
        int[] dimensions = new int[dims.size()];
        int j = 0;
        Iterator i = dims.iterator();
        while (i.hasNext()) {
            dimensions[j++] = (Integer)i.next();
        }
        return dimensions;
    }

    public static Object toArray(JSONArray jsonArray2) {
        return JSONArray.toArray(jsonArray2, new JsonConfig());
    }

    public static Object toArray(JSONArray jsonArray2, Class objectClass) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objectClass);
        return JSONArray.toArray(jsonArray2, jsonConfig);
    }

    public static Object toArray(JSONArray jsonArray2, Class objectClass, Map classMap) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objectClass);
        jsonConfig.setClassMap(classMap);
        return JSONArray.toArray(jsonArray2, jsonConfig);
    }

    public static Object toArray(JSONArray jsonArray2, JsonConfig jsonConfig) {
        Class objectClass = jsonConfig.getRootClass();
        Map classMap = jsonConfig.getClassMap();
        if (jsonArray2.size() == 0) {
            return Array.newInstance(objectClass == null ? Object.class : objectClass, 0);
        }
        int[] dimensions = JSONArray.getDimensions(jsonArray2);
        Object array = Array.newInstance(objectClass == null ? Object.class : objectClass, dimensions);
        int size2 = jsonArray2.size();
        for (int i = 0; i < size2; ++i) {
            Object value2 = jsonArray2.get(i);
            if (JSONUtils.isNull(value2)) {
                Array.set(array, i, null);
                continue;
            }
            Class<?> type = value2.getClass();
            if (JSONArray.class.isAssignableFrom(type)) {
                Array.set(array, i, JSONArray.toArray((JSONArray)value2, objectClass, classMap));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                if (objectClass != null && !objectClass.isAssignableFrom(type)) {
                    value2 = JSONUtils.getMorpherRegistry().morph(objectClass, value2);
                }
                Array.set(array, i, value2);
                continue;
            }
            if (JSONUtils.isNumber(type)) {
                if (objectClass != null && (Byte.class.isAssignableFrom(objectClass) || Byte.TYPE.isAssignableFrom(objectClass))) {
                    Array.set(array, i, Byte.valueOf(String.valueOf(value2)));
                    continue;
                }
                if (objectClass != null && (Short.class.isAssignableFrom(objectClass) || Short.TYPE.isAssignableFrom(objectClass))) {
                    Array.set(array, i, Short.valueOf(String.valueOf(value2)));
                    continue;
                }
                Array.set(array, i, value2);
                continue;
            }
            if (objectClass != null) {
                JsonConfig jsc = jsonConfig.copy();
                jsc.setRootClass(objectClass);
                jsc.setClassMap(classMap);
                Array.set(array, i, JSONObject.toBean((JSONObject)value2, jsc));
                continue;
            }
            Array.set(array, i, JSONObject.toBean((JSONObject)value2));
        }
        return array;
    }

    public static Object toArray(JSONArray jsonArray2, Object root2, JsonConfig jsonConfig) {
        Class<?> objectClass = root2.getClass();
        if (jsonArray2.size() == 0) {
            return Array.newInstance(objectClass, 0);
        }
        int[] dimensions = JSONArray.getDimensions(jsonArray2);
        Object array = Array.newInstance(objectClass == null ? Object.class : objectClass, dimensions);
        int size2 = jsonArray2.size();
        for (int i = 0; i < size2; ++i) {
            Object value2 = jsonArray2.get(i);
            if (JSONUtils.isNull(value2)) {
                Array.set(array, i, null);
                continue;
            }
            Class<?> type = value2.getClass();
            if (JSONArray.class.isAssignableFrom(type)) {
                Array.set(array, i, JSONArray.toArray((JSONArray)value2, root2, jsonConfig));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                if (objectClass != null && !objectClass.isAssignableFrom(type)) {
                    value2 = JSONUtils.getMorpherRegistry().morph(objectClass, value2);
                }
                Array.set(array, i, value2);
                continue;
            }
            try {
                Object newRoot = jsonConfig.getNewBeanInstanceStrategy().newInstance(root2.getClass(), null);
                Array.set(array, i, JSONObject.toBean((JSONObject)value2, newRoot, jsonConfig));
                continue;
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        return array;
    }

    public static Collection toCollection(JSONArray jsonArray2) {
        return JSONArray.toCollection(jsonArray2, new JsonConfig());
    }

    public static Collection toCollection(JSONArray jsonArray2, Class objectClass) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objectClass);
        return JSONArray.toCollection(jsonArray2, jsonConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection toCollection(JSONArray jsonArray2, JsonConfig jsonConfig) {
        AbstractCollection collection = null;
        Class collectionType = jsonConfig.getCollectionType();
        if (collectionType.isInterface()) {
            if (collectionType.equals(List.class)) {
                collection = new ArrayList();
            } else {
                if (!collectionType.equals(Set.class)) throw new JSONException("unknown interface: " + collectionType);
                collection = new HashSet();
            }
        } else {
            try {
                collection = (ArrayList)collectionType.newInstance();
            }
            catch (InstantiationException e) {
                throw new JSONException(e);
            }
            catch (IllegalAccessException e) {
                throw new JSONException(e);
            }
        }
        Class objectClass = jsonConfig.getRootClass();
        Map classMap = jsonConfig.getClassMap();
        int size2 = jsonArray2.size();
        for (int i = 0; i < size2; ++i) {
            Object value2 = jsonArray2.get(i);
            if (JSONUtils.isNull(value2)) {
                collection.add(null);
                continue;
            }
            Class<?> type = value2.getClass();
            if (JSONArray.class.isAssignableFrom(value2.getClass())) {
                collection.add(JSONArray.toCollection((JSONArray)value2, jsonConfig));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                if (objectClass != null && !objectClass.isAssignableFrom(type)) {
                    value2 = JSONUtils.getMorpherRegistry().morph(objectClass, value2);
                }
                collection.add(value2);
                continue;
            }
            if (objectClass != null) {
                JsonConfig jsc = jsonConfig.copy();
                jsc.setRootClass(objectClass);
                jsc.setClassMap(classMap);
                collection.add(JSONObject.toBean((JSONObject)value2, jsc));
                continue;
            }
            collection.add(JSONObject.toBean((JSONObject)value2));
        }
        return collection;
    }

    public static List toList(JSONArray jsonArray2) {
        return JSONArray.toList(jsonArray2, new JsonConfig());
    }

    public static List toList(JSONArray jsonArray2, Class objectClass) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objectClass);
        return JSONArray.toList(jsonArray2, jsonConfig);
    }

    public static List toList(JSONArray jsonArray2, Class objectClass, Map classMap) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objectClass);
        jsonConfig.setClassMap(classMap);
        return JSONArray.toList(jsonArray2, jsonConfig);
    }

    public static List toList(JSONArray jsonArray2, JsonConfig jsonConfig) {
        if (jsonArray2.size() == 0) {
            return new ArrayList();
        }
        Class objectClass = jsonConfig.getRootClass();
        Map classMap = jsonConfig.getClassMap();
        ArrayList<Object> list = new ArrayList<Object>();
        int size2 = jsonArray2.size();
        for (int i = 0; i < size2; ++i) {
            Object value2 = jsonArray2.get(i);
            if (JSONUtils.isNull(value2)) {
                list.add(null);
                continue;
            }
            Class<?> type = value2.getClass();
            if (JSONArray.class.isAssignableFrom(type)) {
                list.add(JSONArray.toList((JSONArray)value2, objectClass, classMap));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                if (objectClass != null && !objectClass.isAssignableFrom(type)) {
                    value2 = JSONUtils.getMorpherRegistry().morph(objectClass, value2);
                }
                list.add(value2);
                continue;
            }
            if (objectClass != null) {
                JsonConfig jsc = jsonConfig.copy();
                jsc.setRootClass(objectClass);
                jsc.setClassMap(classMap);
                list.add(JSONObject.toBean((JSONObject)value2, jsc));
                continue;
            }
            list.add(JSONObject.toBean((JSONObject)value2));
        }
        return list;
    }

    public static List toList(JSONArray jsonArray2, Object root2, JsonConfig jsonConfig) {
        if (jsonArray2.size() == 0 || root2 == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int size2 = jsonArray2.size();
        for (int i = 0; i < size2; ++i) {
            Object value2 = jsonArray2.get(i);
            if (JSONUtils.isNull(value2)) {
                list.add(null);
                continue;
            }
            Class<?> type = value2.getClass();
            if (JSONArray.class.isAssignableFrom(type)) {
                list.add(JSONArray.toList((JSONArray)value2, root2, jsonConfig));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                list.add(value2);
                continue;
            }
            try {
                Object newRoot = jsonConfig.getNewBeanInstanceStrategy().newInstance(root2.getClass(), null);
                list.add(JSONObject.toBean((JSONObject)value2, newRoot, jsonConfig));
                continue;
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        return list;
    }

    private static JSONArray _fromArray(boolean[] array, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Boolean b = array[i] ? Boolean.TRUE : Boolean.FALSE;
            jsonArray2.addValue(b, jsonConfig);
            JSONArray.fireElementAddedEvent(i, b, jsonConfig);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromArray(byte[] array, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Number n = JSONUtils.transformNumber(new Byte(array[i]));
            jsonArray2.addValue(n, jsonConfig);
            JSONArray.fireElementAddedEvent(i, n, jsonConfig);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromArray(char[] array, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Character c = new Character(array[i]);
            jsonArray2.addValue(c, jsonConfig);
            JSONArray.fireElementAddedEvent(i, c, jsonConfig);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromArray(double[] array, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        try {
            for (int i = 0; i < array.length; ++i) {
                Double d = new Double(array[i]);
                JSONUtils.testValidity(d);
                jsonArray2.addValue(d, jsonConfig);
                JSONArray.fireElementAddedEvent(i, d, jsonConfig);
            }
        }
        catch (JSONException jsone) {
            JSONArray.removeInstance(array);
            JSONArray.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromArray(Enum e, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(e)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(e);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException re) {
                JSONArray.removeInstance(e);
                JSONException jsone = new JSONException(re);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        if (e == null) {
            JSONException jsone = new JSONException("enum value is null");
            JSONArray.removeInstance(e);
            JSONArray.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        jsonArray2.addValue(e, jsonConfig);
        JSONArray.fireElementAddedEvent(0, jsonArray2.get(0), jsonConfig);
        JSONArray.removeInstance(e);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromArray(float[] array, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        try {
            for (int i = 0; i < array.length; ++i) {
                Float f = new Float(array[i]);
                JSONUtils.testValidity(f);
                jsonArray2.addValue(f, jsonConfig);
                JSONArray.fireElementAddedEvent(i, f, jsonConfig);
            }
        }
        catch (JSONException jsone) {
            JSONArray.removeInstance(array);
            JSONArray.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromArray(int[] array, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Integer n = new Integer(array[i]);
            jsonArray2.addValue(n, jsonConfig);
            JSONArray.fireElementAddedEvent(i, n, jsonConfig);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromArray(long[] array, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Number n = JSONUtils.transformNumber(new Long(array[i]));
            jsonArray2.addValue(n, jsonConfig);
            JSONArray.fireElementAddedEvent(i, n, jsonConfig);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromArray(Object[] array, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        try {
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                jsonArray2.addValue(element, jsonConfig);
                JSONArray.fireElementAddedEvent(i, jsonArray2.get(i), jsonConfig);
            }
        }
        catch (JSONException jsone) {
            JSONArray.removeInstance(array);
            JSONArray.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONArray.removeInstance(array);
            JSONException jsone = new JSONException(e);
            JSONArray.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromArray(short[] array, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        for (int i = 0; i < array.length; ++i) {
            Number n = JSONUtils.transformNumber(new Short(array[i]));
            jsonArray2.addValue(n, jsonConfig);
            JSONArray.fireElementAddedEvent(i, n, jsonConfig);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromCollection(Collection collection, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(collection)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(collection);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(collection);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(collection);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        try {
            int i = 0;
            for (Object element : collection) {
                jsonArray2.addValue(element, jsonConfig);
                JSONArray.fireElementAddedEvent(i, jsonArray2.get(i++), jsonConfig);
            }
        }
        catch (JSONException jsone) {
            JSONArray.removeInstance(collection);
            JSONArray.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONArray.removeInstance(collection);
            JSONException jsone = new JSONException(e);
            JSONArray.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONArray.removeInstance(collection);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromJSONArray(JSONArray array, JsonConfig jsonConfig) {
        if (!JSONArray.addInstance(array)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsArray(array);
            }
            catch (JSONException jsone) {
                JSONArray.removeInstance(array);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONArray.removeInstance(array);
                JSONException jsone = new JSONException(e);
                JSONArray.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONArray.fireArrayStartEvent(jsonConfig);
        JSONArray jsonArray2 = new JSONArray();
        int index2 = 0;
        for (Object element : array) {
            jsonArray2.addValue(element, jsonConfig);
            JSONArray.fireElementAddedEvent(index2++, element, jsonConfig);
        }
        JSONArray.removeInstance(array);
        JSONArray.fireArrayEndEvent(jsonConfig);
        return jsonArray2;
    }

    private static JSONArray _fromJSONString(JSONString string2, JsonConfig jsonConfig) {
        return JSONArray._fromJSONTokener(new JSONTokener(string2.toJSONString()), jsonConfig);
    }

    private static JSONArray _fromJSONTokener(JSONTokener tokener, JsonConfig jsonConfig) {
        JSONArray jsonArray2 = new JSONArray();
        int index2 = 0;
        try {
            if (tokener.nextClean() != '[') {
                throw tokener.syntaxError("A JSONArray text must start with '['");
            }
            JSONArray.fireArrayStartEvent(jsonConfig);
            if (tokener.nextClean() == ']') {
                JSONArray.fireArrayEndEvent(jsonConfig);
                return jsonArray2;
            }
            tokener.back();
            block6: while (true) {
                if (tokener.nextClean() == ',') {
                    tokener.back();
                    jsonArray2.elements.add(JSONNull.getInstance());
                    JSONArray.fireElementAddedEvent(index2, jsonArray2.get(index2++), jsonConfig);
                } else {
                    tokener.back();
                    Object v = tokener.nextValue(jsonConfig);
                    if (!JSONUtils.isFunctionHeader(v)) {
                        if (v instanceof String && JSONUtils.mayBeJSON((String)v)) {
                            jsonArray2.addValue("\"" + v + "\"", jsonConfig);
                        } else {
                            jsonArray2.addValue(v, jsonConfig);
                        }
                        JSONArray.fireElementAddedEvent(index2, jsonArray2.get(index2++), jsonConfig);
                    } else {
                        char ch;
                        String params = JSONUtils.getFunctionParams((String)v);
                        int i = 0;
                        StringBuffer sb = new StringBuffer();
                        while ((ch = tokener.next()) != '\u0000') {
                            if (ch == '{') {
                                ++i;
                            }
                            if (ch == '}') {
                                --i;
                            }
                            sb.append(ch);
                            if (i != 0) continue;
                            break;
                        }
                        if (i != 0) {
                            throw tokener.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                        }
                        String text = sb.toString();
                        text = text.substring(1, text.length() - 1).trim();
                        jsonArray2.addValue(new JSONFunction(params != null ? StringUtils.split(params, ",") : null, text), jsonConfig);
                        JSONArray.fireElementAddedEvent(index2, jsonArray2.get(index2++), jsonConfig);
                    }
                }
                switch (tokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (tokener.nextClean() == ']') {
                            JSONArray.fireArrayEndEvent(jsonConfig);
                            return jsonArray2;
                        }
                        tokener.back();
                        continue block6;
                    }
                    case ']': {
                        JSONArray.fireArrayEndEvent(jsonConfig);
                        return jsonArray2;
                    }
                }
                break;
            }
            throw tokener.syntaxError("Expected a ',' or ']'");
        }
        catch (JSONException jsone) {
            JSONArray.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
    }

    private static JSONArray _fromString(String string2, JsonConfig jsonConfig) {
        return JSONArray._fromJSONTokener(new JSONTokener(string2), jsonConfig);
    }

    private static void processArrayDimensions(JSONArray jsonArray2, List dims, int index2) {
        if (dims.size() <= index2) {
            dims.add(new Integer(jsonArray2.size()));
        } else {
            int i = (Integer)dims.get(index2);
            if (jsonArray2.size() > i) {
                dims.set(index2, new Integer(jsonArray2.size()));
            }
        }
        for (Object item : jsonArray2) {
            if (!(item instanceof JSONArray)) continue;
            JSONArray.processArrayDimensions((JSONArray)item, dims, index2 + 1);
        }
    }

    public void add(int index2, Object value2) {
        this.add(index2, value2, new JsonConfig());
    }

    public void add(int index2, Object value2, JsonConfig jsonConfig) {
        this.elements.add(index2, this.processValue(value2, jsonConfig));
    }

    public boolean add(Object value2) {
        return this.add(value2, new JsonConfig());
    }

    public boolean add(Object value2, JsonConfig jsonConfig) {
        this.element(value2, jsonConfig);
        return true;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(collection, new JsonConfig());
    }

    public boolean addAll(Collection collection, JsonConfig jsonConfig) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            this.element(i.next(), jsonConfig);
        }
        return true;
    }

    public boolean addAll(int index2, Collection collection) {
        return this.addAll(index2, collection, new JsonConfig());
    }

    public boolean addAll(int index2, Collection collection, JsonConfig jsonConfig) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        int offset = 0;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            this.elements.add(index2 + offset++, this.processValue(i.next(), jsonConfig));
        }
        return true;
    }

    public void clear() {
        this.elements.clear();
    }

    public int compareTo(Object obj) {
        if (obj != null && obj instanceof JSONArray) {
            int size2;
            JSONArray other = (JSONArray)obj;
            int size1 = this.size();
            if (size1 < (size2 = other.size())) {
                return -1;
            }
            if (size1 > size2) {
                return 1;
            }
            if (this.equals(other)) {
                return 0;
            }
        }
        return -1;
    }

    public boolean contains(Object o) {
        return this.contains(o, new JsonConfig());
    }

    public boolean contains(Object o, JsonConfig jsonConfig) {
        return this.elements.contains(this.processValue(o, jsonConfig));
    }

    public boolean containsAll(Collection collection) {
        return this.containsAll(collection, new JsonConfig());
    }

    public boolean containsAll(Collection collection, JsonConfig jsonConfig) {
        return this.elements.containsAll(JSONArray.fromObject(collection, jsonConfig));
    }

    public JSONArray discard(int index2) {
        this.elements.remove(index2);
        return this;
    }

    public JSONArray discard(Object o) {
        this.elements.remove(o);
        return this;
    }

    public JSONArray element(boolean value2) {
        return this.element(value2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONArray element(Collection value2) {
        return this.element(value2, new JsonConfig());
    }

    public JSONArray element(Collection value2, JsonConfig jsonConfig) {
        if (value2 instanceof JSONArray) {
            this.elements.add(value2);
            return this;
        }
        return this.element(JSONArray._fromCollection(value2, jsonConfig));
    }

    public JSONArray element(double value2) {
        Double d = new Double(value2);
        JSONUtils.testValidity(d);
        return this.element(d);
    }

    public JSONArray element(int value2) {
        return this.element(new Integer(value2));
    }

    public JSONArray element(int index2, boolean value2) {
        return this.element(index2, value2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONArray element(int index2, Collection value2) {
        return this.element(index2, value2, new JsonConfig());
    }

    public JSONArray element(int index2, Collection value2, JsonConfig jsonConfig) {
        if (value2 instanceof JSONArray) {
            if (index2 < 0) {
                throw new JSONException("JSONArray[" + index2 + "] not found.");
            }
            if (index2 < this.size()) {
                this.elements.set(index2, value2);
            } else {
                while (index2 != this.size()) {
                    this.element(JSONNull.getInstance());
                }
                this.element(value2, jsonConfig);
            }
            return this;
        }
        return this.element(index2, JSONArray._fromCollection(value2, jsonConfig));
    }

    public JSONArray element(int index2, double value2) {
        return this.element(index2, new Double(value2));
    }

    public JSONArray element(int index2, int value2) {
        return this.element(index2, new Integer(value2));
    }

    public JSONArray element(int index2, long value2) {
        return this.element(index2, new Long(value2));
    }

    public JSONArray element(int index2, Map value2) {
        return this.element(index2, value2, new JsonConfig());
    }

    public JSONArray element(int index2, Map value2, JsonConfig jsonConfig) {
        if (value2 instanceof JSONObject) {
            if (index2 < 0) {
                throw new JSONException("JSONArray[" + index2 + "] not found.");
            }
            if (index2 < this.size()) {
                this.elements.set(index2, value2);
            } else {
                while (index2 != this.size()) {
                    this.element(JSONNull.getInstance());
                }
                this.element(value2, jsonConfig);
            }
            return this;
        }
        return this.element(index2, JSONObject.fromObject(value2, jsonConfig));
    }

    public JSONArray element(int index2, Object value2) {
        return this.element(index2, value2, new JsonConfig());
    }

    public JSONArray element(int index2, Object value2, JsonConfig jsonConfig) {
        JSONUtils.testValidity(value2);
        if (index2 < 0) {
            throw new JSONException("JSONArray[" + index2 + "] not found.");
        }
        if (index2 < this.size()) {
            this.elements.set(index2, this.processValue(value2, jsonConfig));
        } else {
            while (index2 != this.size()) {
                this.element(JSONNull.getInstance());
            }
            this.element(value2, jsonConfig);
        }
        return this;
    }

    public JSONArray element(int index2, String value2) {
        return this.element(index2, value2, new JsonConfig());
    }

    public JSONArray element(int index2, String value2, JsonConfig jsonConfig) {
        if (index2 < 0) {
            throw new JSONException("JSONArray[" + index2 + "] not found.");
        }
        if (index2 < this.size()) {
            if (value2 == null) {
                this.elements.set(index2, "");
            } else if (JSONUtils.mayBeJSON(value2)) {
                try {
                    this.elements.set(index2, JSONSerializer.toJSON((Object)value2, jsonConfig));
                }
                catch (JSONException jsone) {
                    this.elements.set(index2, JSONUtils.stripQuotes(value2));
                }
            } else {
                this.elements.set(index2, JSONUtils.stripQuotes(value2));
            }
        } else {
            while (index2 != this.size()) {
                this.element(JSONNull.getInstance());
            }
            this.element(value2, jsonConfig);
        }
        return this;
    }

    public JSONArray element(JSONNull value2) {
        this.elements.add(value2);
        return this;
    }

    public JSONArray element(JSONObject value2) {
        this.elements.add(value2);
        return this;
    }

    public JSONArray element(long value2) {
        return this.element(JSONUtils.transformNumber(new Long(value2)));
    }

    public JSONArray element(Map value2) {
        return this.element(value2, new JsonConfig());
    }

    public JSONArray element(Map value2, JsonConfig jsonConfig) {
        if (value2 instanceof JSONObject) {
            this.elements.add(value2);
            return this;
        }
        return this.element(JSONObject.fromObject(value2, jsonConfig));
    }

    public JSONArray element(Object value2) {
        return this.element(value2, new JsonConfig());
    }

    public JSONArray element(Object value2, JsonConfig jsonConfig) {
        return this.addValue(value2, jsonConfig);
    }

    public JSONArray element(String value2) {
        return this.element(value2, new JsonConfig());
    }

    public JSONArray element(String value2, JsonConfig jsonConfig) {
        if (value2 == null) {
            this.elements.add("");
        } else if (JSONUtils.hasQuotes(value2)) {
            this.elements.add(value2);
        } else if (JSONNull.getInstance().equals(value2)) {
            this.elements.add(JSONNull.getInstance());
        } else if (JSONUtils.isJsonKeyword(value2, jsonConfig)) {
            if (jsonConfig.isJavascriptCompliant() && "undefined".equals(value2)) {
                this.elements.add(JSONNull.getInstance());
            } else {
                this.elements.add(value2);
            }
        } else if (JSONUtils.mayBeJSON(value2)) {
            try {
                this.elements.add(JSONSerializer.toJSON((Object)value2, jsonConfig));
            }
            catch (JSONException jsone) {
                this.elements.add(value2);
            }
        } else {
            this.elements.add(value2);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONArray)) {
            return false;
        }
        JSONArray other = (JSONArray)obj;
        if (other.size() != this.size()) {
            return false;
        }
        int max2 = this.size();
        for (int i = 0; i < max2; ++i) {
            Object o1 = this.get(i);
            Object o2 = other.get(i);
            if (JSONNull.getInstance().equals(o1)) {
                if (JSONNull.getInstance().equals(o2)) continue;
                return false;
            }
            if (JSONNull.getInstance().equals(o2)) {
                return false;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                JSONArray a = (JSONArray)o2;
                JSONArray e = (JSONArray)o1;
                if (a.equals(e)) continue;
                return false;
            }
            if (o1 instanceof String && o2 instanceof JSONFunction) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            if (o1 instanceof JSONObject && o2 instanceof JSONObject) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof JSONFunction) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof String) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            Morpher m1 = JSONUtils.getMorpherRegistry().getMorpherFor(o1.getClass());
            Morpher m2 = JSONUtils.getMorpherRegistry().getMorpherFor(o2.getClass());
            if (!(m1 != null && m1 != IdentityObjectMorpher.getInstance() ? !o1.equals(JSONUtils.getMorpherRegistry().morph(o1.getClass(), o2)) : (m2 != null && m2 != IdentityObjectMorpher.getInstance() ? !JSONUtils.getMorpherRegistry().morph(o1.getClass(), o1).equals(o2) : !o1.equals(o2)))) continue;
            return false;
        }
        return true;
    }

    public Object get(int index2) {
        return this.elements.get(index2);
    }

    public boolean getBoolean(int index2) {
        Object o = this.get(index2);
        if (o != null) {
            if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
                return false;
            }
            if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
                return true;
            }
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a Boolean.");
    }

    public double getDouble(int index2) {
        Object o = this.get(index2);
        if (o != null) {
            try {
                return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
            }
            catch (Exception e) {
                throw new JSONException("JSONArray[" + index2 + "] is not a number.");
            }
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a number.");
    }

    public int getInt(int index2) {
        Object o = this.get(index2);
        if (o != null) {
            return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index2);
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a number.");
    }

    public JSONArray getJSONArray(int index2) {
        Object o = this.get(index2);
        if (o != null && o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index2) {
        Object o = this.get(index2);
        if (JSONNull.getInstance().equals(o)) {
            return new JSONObject(true);
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a JSONObject.");
    }

    public long getLong(int index2) {
        Object o = this.get(index2);
        if (o != null) {
            return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(index2);
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a number.");
    }

    public String getString(int index2) {
        Object o = this.get(index2);
        if (o != null) {
            return o.toString();
        }
        throw new JSONException("JSONArray[" + index2 + "] not found.");
    }

    public int hashCode() {
        int hashcode = 29;
        for (Object element : this.elements) {
            hashcode += JSONUtils.hashCode(element);
        }
        return hashcode;
    }

    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    public boolean isArray() {
        return true;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean isExpandElements() {
        return this.expandElements;
    }

    public Iterator iterator() {
        return new JSONArrayListIterator();
    }

    public String join(String separator) {
        return this.join(separator, false);
    }

    public String join(String separator, boolean stripQuotes) {
        int len2 = this.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len2; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            String value2 = JSONUtils.valueToString(this.elements.get(i));
            sb.append(stripQuotes ? JSONUtils.stripQuotes(value2) : value2);
        }
        return sb.toString();
    }

    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index2) {
        if (index2 < 0 || index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index2);
        }
        return new JSONArrayListIterator(index2);
    }

    public Object opt(int index2) {
        return index2 < 0 || index2 >= this.size() ? null : this.elements.get(index2);
    }

    public boolean optBoolean(int index2) {
        return this.optBoolean(index2, false);
    }

    public boolean optBoolean(int index2, boolean defaultValue) {
        try {
            return this.getBoolean(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(int index2) {
        return this.optDouble(index2, Double.NaN);
    }

    public double optDouble(int index2, double defaultValue) {
        try {
            return this.getDouble(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(int index2) {
        return this.optInt(index2, 0);
    }

    public int optInt(int index2, int defaultValue) {
        try {
            return this.getInt(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(int index2) {
        Object o = this.opt(index2);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(int index2) {
        Object o = this.opt(index2);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(int index2) {
        return this.optLong(index2, 0L);
    }

    public long optLong(int index2, long defaultValue) {
        try {
            return this.getLong(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(int index2) {
        return this.optString(index2, "");
    }

    public String optString(int index2, String defaultValue) {
        Object o = this.opt(index2);
        return o != null ? o.toString() : defaultValue;
    }

    public Object remove(int index2) {
        return this.elements.remove(index2);
    }

    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    public boolean removeAll(Collection collection) {
        return this.removeAll(collection, new JsonConfig());
    }

    public boolean removeAll(Collection collection, JsonConfig jsonConfig) {
        return this.elements.removeAll(JSONArray.fromObject(collection, jsonConfig));
    }

    public boolean retainAll(Collection collection) {
        return this.retainAll(collection, new JsonConfig());
    }

    public boolean retainAll(Collection collection, JsonConfig jsonConfig) {
        return this.elements.retainAll(JSONArray.fromObject(collection, jsonConfig));
    }

    public Object set(int index2, Object value2) {
        return this.set(index2, value2, new JsonConfig());
    }

    public Object set(int index2, Object value2, JsonConfig jsonConfig) {
        Object previous = this.get(index2);
        this.element(index2, value2, jsonConfig);
        return previous;
    }

    public void setExpandElements(boolean expandElements) {
        this.expandElements = expandElements;
    }

    public int size() {
        return this.elements.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.elements.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.elements.toArray(array);
    }

    public JSONObject toJSONObject(JSONArray names) {
        if (names == null || names.size() == 0 || this.size() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i = 0; i < names.size(); ++i) {
            jo.element(names.getString(i), this.opt(i));
        }
        return jo;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) {
        if (indentFactor == 0) {
            return this.toString();
        }
        return this.toString(indentFactor, 0);
    }

    public String toString(int indentFactor, int indent) {
        int len2 = this.size();
        if (len2 == 0) {
            return "[]";
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        StringBuffer sb = new StringBuffer("[");
        if (len2 == 1) {
            sb.append(JSONUtils.valueToString(this.elements.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len2; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.valueToString(this.elements.get(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
            for (i = 0; i < indent; ++i) {
                sb.insert(0, ' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public Writer write(Writer writer) {
        try {
            boolean b = false;
            int len2 = this.size();
            writer.write(91);
            for (int i = 0; i < len2; ++i) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = this.elements.get(i)) instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONUtils.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    protected JSONArray addString(String str) {
        if (str != null) {
            this.elements.add(str);
        }
        return this;
    }

    private JSONArray _addValue(Object value2, JsonConfig jsonConfig) {
        this.elements.add(value2);
        return this;
    }

    protected Object _processValue(Object value2, JsonConfig jsonConfig) {
        if (value2 instanceof JSONTokener) {
            return JSONArray._fromJSONTokener((JSONTokener)value2, jsonConfig);
        }
        if (value2 != null && Enum.class.isAssignableFrom(value2.getClass())) {
            return ((Enum)value2).name();
        }
        if (value2 instanceof Annotation || value2 != null && value2.getClass().isAnnotation()) {
            throw new JSONException("Unsupported type");
        }
        return super._processValue(value2, jsonConfig);
    }

    private JSONArray addValue(Object value2, JsonConfig jsonConfig) {
        return this._addValue(this.processValue(value2, jsonConfig), jsonConfig);
    }

    private Object processValue(Object value2, JsonConfig jsonConfig) {
        JsonValueProcessor jsonValueProcessor;
        if (value2 != null && (jsonValueProcessor = jsonConfig.findJsonValueProcessor(value2.getClass())) != null && !JsonVerifier.isValidJsonValue(value2 = jsonValueProcessor.processArrayValue(value2, jsonConfig))) {
            throw new JSONException("Value is not a valid JSON value. " + value2);
        }
        return this._processValue(value2, jsonConfig);
    }

    private class JSONArrayListIterator
    implements ListIterator {
        int currentIndex = 0;
        int lastIndex = -1;

        JSONArrayListIterator() {
        }

        JSONArrayListIterator(int index2) {
            this.currentIndex = index2;
        }

        public boolean hasNext() {
            return this.currentIndex != JSONArray.this.size();
        }

        public Object next() {
            try {
                Object next2 = JSONArray.this.get(this.currentIndex);
                this.lastIndex = this.currentIndex++;
                return next2;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            try {
                JSONArray.this.remove(this.lastIndex);
                if (this.lastIndex < this.currentIndex) {
                    --this.currentIndex;
                }
                this.lastIndex = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasPrevious() {
            return this.currentIndex != 0;
        }

        public Object previous() {
            try {
                int index2 = this.currentIndex - 1;
                Object previous = JSONArray.this.get(index2);
                this.lastIndex = this.currentIndex = index2;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.currentIndex;
        }

        public int previousIndex() {
            return this.currentIndex - 1;
        }

        public void set(Object obj) {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            try {
                JSONArray.this.set(this.lastIndex, obj);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object obj) {
            try {
                JSONArray.this.add(this.currentIndex++, obj);
                this.lastIndex = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

