/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.net.sf.json.util;

import com.alibaba.schedulerx.shade.net.sf.json.JSONArray;
import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONNull;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import com.alibaba.schedulerx.shade.net.sf.json.JsonConfig;
import com.alibaba.schedulerx.shade.net.sf.json.regexp.RegexpUtils;
import com.alibaba.schedulerx.shade.net.sf.json.util.JSONUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.math.NumberUtils;

public class JSONTokener {
    private int myIndex = 0;
    private String mySource;

    public static int dehexchar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    public JSONTokener(String s2) {
        s2 = s2 != null ? s2.trim() : "";
        if (s2.length() > 0) {
            char first = s2.charAt(0);
            char last2 = s2.charAt(s2.length() - 1);
            if (first == '[' && last2 != ']') {
                throw this.syntaxError("Found starting '[' but missing ']' at the end.");
            }
            if (first == '{' && last2 != '}') {
                throw this.syntaxError("Found starting '{' but missing '}' at the end.");
            }
        }
        this.mySource = s2;
    }

    public void back() {
        if (this.myIndex > 0) {
            --this.myIndex;
        }
    }

    public int length() {
        if (this.mySource == null) {
            return 0;
        }
        return this.mySource.length();
    }

    public boolean matches(String pattern) {
        String str = this.mySource.substring(this.myIndex);
        return RegexpUtils.getMatcher(pattern).matches(str);
    }

    public boolean more() {
        return this.myIndex < this.mySource.length();
    }

    public char next() {
        if (this.more()) {
            char c = this.mySource.charAt(this.myIndex);
            ++this.myIndex;
            return c;
        }
        return '\u0000';
    }

    public char next(char c) {
        char n = this.next();
        if (n != c) {
            throw this.syntaxError("Expected '" + c + "' and instead saw '" + n + "'.");
        }
        return n;
    }

    public String next(int n) {
        int i = this.myIndex;
        int j = i + n;
        if (j >= this.mySource.length()) {
            throw this.syntaxError("Substring bounds error");
        }
        this.myIndex += n;
        return this.mySource.substring(i, j);
    }

    public char nextClean() {
        char c;
        block4: while (true) {
            if ((c = this.next()) == '/') {
                switch (this.next()) {
                    case '/': {
                        while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c = this.next()) == '\u0000') {
                                throw this.syntaxError("Unclosed comment.");
                            }
                            if (c != '*') continue;
                            if (this.next() == '/') continue block4;
                            this.back();
                        }
                    }
                    default: {
                        this.back();
                        return '/';
                    }
                }
            }
            if (c == '#') {
                while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                }
                continue;
            }
            if (c == '\u0000' || c > ' ') break;
        }
        return c;
    }

    public String nextString(char quote) {
        StringBuffer sb = new StringBuffer();
        block13: while (true) {
            char c = this.next();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c = this.next();
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block13;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            sb.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case 'x': {
                            sb.append((char)Integer.parseInt(this.next(2), 16));
                            continue block13;
                        }
                    }
                    sb.append(c);
                    continue block13;
                }
            }
            if (c == quote) {
                return sb.toString();
            }
            sb.append(c);
        }
    }

    public String nextTo(char d) {
        StringBuffer sb = new StringBuffer();
        while (true) {
            char c;
            if ((c = this.next()) == d || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return sb.toString().trim();
            }
            sb.append(c);
        }
    }

    public String nextTo(String delimiters) {
        StringBuffer sb = new StringBuffer();
        while (true) {
            char c;
            if (delimiters.indexOf(c = this.next()) >= 0 || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return sb.toString().trim();
            }
            sb.append(c);
        }
    }

    public Object nextValue() {
        return this.nextValue(new JsonConfig());
    }

    public Object nextValue(JsonConfig jsonConfig) {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
            case '{': {
                this.back();
                return JSONObject.fromObject(this, jsonConfig);
            }
            case '[': {
                this.back();
                return JSONArray.fromObject(this, jsonConfig);
            }
        }
        StringBuffer sb = new StringBuffer();
        char b = c;
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append(c);
            c = this.next();
        }
        this.back();
        String s2 = sb.toString().trim();
        if (s2.equals("")) {
            throw this.syntaxError("Missing value.");
        }
        if (s2.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s2.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (s2.equals("null") || jsonConfig.isJavascriptCompliant() && s2.equals("undefined")) {
            return JSONNull.getInstance();
        }
        if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
            if (b == '0') {
                if (s2.length() > 2 && (s2.charAt(1) == 'x' || s2.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(s2.substring(2), 16));
                    }
                    catch (Exception e) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(s2, 8));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            try {
                return NumberUtils.createNumber(s2);
            }
            catch (Exception e) {
                return s2;
            }
        }
        if (JSONUtils.isFunctionHeader(s2) || JSONUtils.isFunction(s2)) {
            return s2;
        }
        switch (this.peek()) {
            case ',': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                throw new JSONException("Unquotted string '" + s2 + "'");
            }
        }
        return s2;
    }

    public char peek() {
        if (this.more()) {
            char c = this.mySource.charAt(this.myIndex);
            return c;
        }
        return '\u0000';
    }

    public void reset() {
        this.myIndex = 0;
    }

    public void skipPast(String to2) {
        this.myIndex = this.mySource.indexOf(to2, this.myIndex);
        this.myIndex = this.myIndex < 0 ? this.mySource.length() : (this.myIndex += to2.length());
    }

    public char skipTo(char to2) {
        char c;
        int index2 = this.myIndex;
        do {
            if ((c = this.next()) != '\u0000') continue;
            this.myIndex = index2;
            return c;
        } while (c != to2);
        this.back();
        return c;
    }

    public JSONException syntaxError(String message) {
        return new JSONException(message + this.toString());
    }

    public String toString() {
        return " at character " + this.myIndex + " of " + this.mySource;
    }
}

