/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.beanutils.converters;

import com.alibaba.schedulerx.shade.org.apache.commons.beanutils.ConversionException;
import com.alibaba.schedulerx.shade.org.apache.commons.beanutils.converters.AbstractConverter;

public final class BooleanConverter
extends AbstractConverter {
    public static final Object NO_DEFAULT = new Object();
    private String[] trueStrings = new String[]{"true", "yes", "y", "on", "1"};
    private String[] falseStrings = new String[]{"false", "no", "n", "off", "0"};
    static /* synthetic */ Class class$java$lang$Boolean;

    public BooleanConverter() {
    }

    public BooleanConverter(Object defaultValue) {
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings, Object defaultValue) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    protected Class getDefaultType() {
        return class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean;
    }

    protected Object convertToType(Class type, Object value2) throws Throwable {
        int i;
        String stringValue = value2.toString().toLowerCase();
        for (i = 0; i < this.trueStrings.length; ++i) {
            if (!this.trueStrings[i].equals(stringValue)) continue;
            return Boolean.TRUE;
        }
        for (i = 0; i < this.falseStrings.length; ++i) {
            if (!this.falseStrings[i].equals(stringValue)) continue;
            return Boolean.FALSE;
        }
        throw new ConversionException("Cna't convert value '" + value2 + "' to a Boolean");
    }

    private static String[] copyStrings(String[] src) {
        String[] dst = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i].toLowerCase();
        }
        return dst;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

