/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.codec.net;

import com.alibaba.schedulerx.shade.org.apache.commons.codec.Charsets;
import com.alibaba.schedulerx.shade.org.apache.commons.codec.DecoderException;
import com.alibaba.schedulerx.shade.org.apache.commons.codec.EncoderException;
import com.alibaba.schedulerx.shade.org.apache.commons.codec.StringDecoder;
import com.alibaba.schedulerx.shade.org.apache.commons.codec.StringEncoder;
import com.alibaba.schedulerx.shade.org.apache.commons.codec.binary.Base64;
import com.alibaba.schedulerx.shade.org.apache.commons.codec.net.RFC1522Codec;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class BCodec
extends RFC1522Codec
implements StringEncoder,
StringDecoder {
    private final Charset charset;

    public BCodec() {
        this(Charsets.UTF_8);
    }

    public BCodec(Charset charset) {
        this.charset = charset;
    }

    public BCodec(String charsetName) {
        this(Charset.forName(charsetName));
    }

    @Override
    protected String getEncoding() {
        return "B";
    }

    @Override
    protected byte[] doEncoding(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Base64.encodeBase64(bytes);
    }

    @Override
    protected byte[] doDecoding(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Base64.decodeBase64(bytes);
    }

    public String encode(String value2, Charset charset) throws EncoderException {
        if (value2 == null) {
            return null;
        }
        return this.encodeText(value2, charset);
    }

    public String encode(String value2, String charset) throws EncoderException {
        if (value2 == null) {
            return null;
        }
        try {
            return this.encodeText(value2, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e.getMessage(), e);
        }
    }

    @Override
    public String encode(String value2) throws EncoderException {
        if (value2 == null) {
            return null;
        }
        return this.encode(value2, this.getCharset());
    }

    @Override
    public String decode(String value2) throws DecoderException {
        if (value2 == null) {
            return null;
        }
        try {
            return this.decodeText(value2);
        }
        catch (UnsupportedEncodingException e) {
            throw new DecoderException(e.getMessage(), e);
        }
    }

    @Override
    public Object encode(Object value2) throws EncoderException {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return this.encode((String)value2);
        }
        throw new EncoderException("Objects of type " + value2.getClass().getName() + " cannot be encoded using BCodec");
    }

    @Override
    public Object decode(Object value2) throws DecoderException {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return this.decode((String)value2);
        }
        throw new DecoderException("Objects of type " + value2.getClass().getName() + " cannot be decoded using BCodec");
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }
}

