/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.collections;

import com.alibaba.schedulerx.shade.org.apache.commons.collections.SequencedHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;

public class LRUMap
extends SequencedHashMap
implements Externalizable {
    private int maximumSize = 0;
    private static final long serialVersionUID = 2197433140769957051L;

    public LRUMap() {
        this(100);
    }

    public LRUMap(int i) {
        super(i);
        this.maximumSize = i;
    }

    public Object get(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        Object value2 = this.remove(key);
        super.put(key, value2);
        return value2;
    }

    public Object put(Object key, Object value2) {
        int mapSize = this.size();
        Object retval = null;
        if (mapSize >= this.maximumSize && !this.containsKey(key)) {
            this.removeLRU();
        }
        retval = super.put(key, value2);
        return retval;
    }

    protected void removeLRU() {
        Object key = this.getFirstKey();
        Object value2 = super.get(key);
        this.remove(key);
        this.processRemovedLRU(key, value2);
    }

    protected void processRemovedLRU(Object key, Object value2) {
    }

    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.maximumSize = in2.readInt();
        int size2 = in2.readInt();
        for (int i = 0; i < size2; ++i) {
            Object key = in2.readObject();
            Object value2 = in2.readObject();
            this.put(key, value2);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.maximumSize);
        out.writeInt(this.size());
        Iterator iterator2 = this.keySet().iterator();
        while (iterator2.hasNext()) {
            Object key = iterator2.next();
            out.writeObject(key);
            Object value2 = super.get(key);
            out.writeObject(value2);
        }
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
        while (this.size() > maximumSize) {
            this.removeLRU();
        }
    }
}

