/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.configuration;

import com.alibaba.schedulerx.shade.org.apache.commons.collections.ExtendedProperties;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.AbstractConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.ConfigurationMap;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.MapConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationConverter {
    private ConfigurationConverter() {
    }

    public static Configuration getConfiguration(ExtendedProperties eprops) {
        return new MapConfiguration(eprops);
    }

    public static Configuration getConfiguration(Properties props2) {
        return new MapConfiguration(props2);
    }

    public static ExtendedProperties getExtendedProperties(Configuration config) {
        ExtendedProperties props2 = new ExtendedProperties();
        Iterator<String> keys = config.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            ArrayList property = config.getProperty(key);
            if (property instanceof List) {
                property = new ArrayList(property);
            }
            props2.setProperty(key, property);
        }
        return props2;
    }

    public static Properties getProperties(Configuration config) {
        Properties props2 = new Properties();
        char delimiter = config instanceof AbstractConfiguration ? (char)((AbstractConfiguration)config).getListDelimiter() : (char)',';
        Iterator<String> keys = config.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            List<Object> list = config.getList(key);
            props2.setProperty(key, StringUtils.join(list.iterator(), delimiter));
        }
        return props2;
    }

    public static Map<Object, Object> getMap(Configuration config) {
        return new ConfigurationMap(config);
    }
}

