/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.configuration.resolver;

import com.alibaba.schedulerx.shade.org.apache.commons.configuration.resolver.EntityRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntityResolver
implements EntityResolver,
EntityRegistry {
    private Map<String, URL> registeredEntities = new HashMap<String, URL>();

    @Override
    public void registerEntityId(String publicId, URL entityURL) {
        if (publicId == null) {
            throw new IllegalArgumentException("Public ID must not be null!");
        }
        this.getRegisteredEntities().put(publicId, entityURL);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        URL entityURL = null;
        if (publicId != null) {
            entityURL = this.getRegisteredEntities().get(publicId);
        }
        if (entityURL != null) {
            try {
                URLConnection connection = entityURL.openConnection();
                connection.setUseCaches(false);
                InputStream stream = connection.getInputStream();
                InputSource source = new InputSource(stream);
                source.setSystemId(entityURL.toExternalForm());
                return source;
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        return null;
    }

    @Override
    public Map<String, URL> getRegisteredEntities() {
        return this.registeredEntities;
    }
}

