/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.impl.nio.client;

import com.alibaba.schedulerx.shade.org.apache.http.HttpHost;
import com.alibaba.schedulerx.shade.org.apache.http.HttpRequest;
import com.alibaba.schedulerx.shade.org.apache.http.HttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.annotation.ThreadSafe;
import com.alibaba.schedulerx.shade.org.apache.http.client.ClientProtocolException;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpUriRequest;
import com.alibaba.schedulerx.shade.org.apache.http.client.utils.URIUtils;
import com.alibaba.schedulerx.shade.org.apache.http.concurrent.BasicFuture;
import com.alibaba.schedulerx.shade.org.apache.http.concurrent.FutureCallback;
import com.alibaba.schedulerx.shade.org.apache.http.nio.client.HttpAsyncClient;
import com.alibaba.schedulerx.shade.org.apache.http.nio.client.methods.HttpAsyncMethods;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.BasicHttpContext;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpContext;
import com.alibaba.schedulerx.shade.org.apache.http.util.Args;
import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
Closeable {
    public abstract boolean isRunning();

    public abstract void start();

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, (HttpContext)new BasicHttpContext(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request2, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.execute(HttpAsyncMethods.create(target, request2), HttpAsyncMethods.createConsumer(), context, callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request2, FutureCallback<HttpResponse> callback) {
        return this.execute(target, request2, (HttpContext)new BasicHttpContext(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request2, FutureCallback<HttpResponse> callback) {
        return this.execute(request2, new BasicHttpContext(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request2, HttpContext context, FutureCallback<HttpResponse> callback) {
        HttpHost target;
        try {
            target = this.determineTarget(request2);
        }
        catch (ClientProtocolException ex) {
            BasicFuture<HttpResponse> future2 = new BasicFuture<HttpResponse>(callback);
            future2.failed(ex);
            return future2;
        }
        return this.execute(target, request2, context, callback);
    }

    private HttpHost determineTarget(HttpUriRequest request2) throws ClientProtocolException {
        Args.notNull(request2, "HTTP request");
        HttpHost target = null;
        URI requestURI = request2.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }
}

