/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.nio.protocol;

import com.alibaba.schedulerx.shade.org.apache.http.HttpRequest;
import com.alibaba.schedulerx.shade.org.apache.http.annotation.ThreadSafe;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.UriPatternMatcher;
import com.alibaba.schedulerx.shade.org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class UriHttpAsyncRequestHandlerMapper
implements HttpAsyncRequestHandlerMapper {
    private final UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher;

    protected UriHttpAsyncRequestHandlerMapper(UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher) {
        this.matcher = Args.notNull(matcher, "Pattern matcher");
    }

    public UriHttpAsyncRequestHandlerMapper() {
        this(new UriPatternMatcher());
    }

    public void register(String pattern, HttpAsyncRequestHandler<?> handler) {
        this.matcher.register(pattern, handler);
    }

    public void unregister(String pattern) {
        this.matcher.unregister(pattern);
    }

    protected String getRequestPath(HttpRequest request2) {
        String uriPath = request2.getRequestLine().getUri();
        int index2 = uriPath.indexOf("?");
        if (index2 != -1) {
            uriPath = uriPath.substring(0, index2);
        } else {
            index2 = uriPath.indexOf("#");
            if (index2 != -1) {
                uriPath = uriPath.substring(0, index2);
            }
        }
        return uriPath;
    }

    @Override
    public HttpAsyncRequestHandler<?> lookup(HttpRequest request2) {
        return this.matcher.lookup(this.getRequestPath(request2));
    }
}

