/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.protocol;

import com.alibaba.schedulerx.shade.org.apache.http.HttpRequest;
import com.alibaba.schedulerx.shade.org.apache.http.annotation.Contract;
import com.alibaba.schedulerx.shade.org.apache.http.annotation.ThreadingBehavior;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpRequestHandler;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpRequestHandlerMapper;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.UriPatternMatcher;
import com.alibaba.schedulerx.shade.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class UriHttpRequestHandlerMapper
implements HttpRequestHandlerMapper {
    private final UriPatternMatcher<HttpRequestHandler> matcher;

    protected UriHttpRequestHandlerMapper(UriPatternMatcher<HttpRequestHandler> matcher) {
        this.matcher = Args.notNull(matcher, "Pattern matcher");
    }

    public UriHttpRequestHandlerMapper() {
        this(new UriPatternMatcher<HttpRequestHandler>());
    }

    public void register(String pattern, HttpRequestHandler handler) {
        Args.notNull(pattern, "Pattern");
        Args.notNull(handler, "Handler");
        this.matcher.register(pattern, handler);
    }

    public void unregister(String pattern) {
        this.matcher.unregister(pattern);
    }

    protected String getRequestPath(HttpRequest request2) {
        String uriPath = request2.getRequestLine().getUri();
        int index2 = uriPath.indexOf("?");
        if (index2 != -1) {
            uriPath = uriPath.substring(0, index2);
        } else {
            index2 = uriPath.indexOf("#");
            if (index2 != -1) {
                uriPath = uriPath.substring(0, index2);
            }
        }
        return uriPath;
    }

    @Override
    public HttpRequestHandler lookup(HttpRequest request2) {
        Args.notNull(request2, "HTTP request");
        return this.matcher.lookup(this.getRequestPath(request2));
    }
}

