/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.ddl;

import com.alibaba.schedulerx.shade.org.h2.command.ddl.SchemaCommand;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.schema.Constant;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.value.Value;

public class CreateConstant
extends SchemaCommand {
    private String constantName;
    private Expression expression;
    private boolean ifNotExists;

    public CreateConstant(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (this.getSchema().findConstant(this.constantName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90114, this.constantName);
        }
        int n = this.getObjectId();
        Constant constant = new Constant(this.getSchema(), n, this.constantName);
        this.expression = this.expression.optimize(this.session);
        Value value2 = this.expression.getValue(this.session);
        constant.setValue(value2);
        database.addSchemaObject(this.session, constant);
        return 0;
    }

    public void setConstantName(String string2) {
        this.constantName = string2;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public int getType() {
        return 23;
    }
}

