/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.dml;

import com.alibaba.schedulerx.shade.org.h2.command.Command;
import com.alibaba.schedulerx.shade.org.h2.command.Prepared;
import com.alibaba.schedulerx.shade.org.h2.command.dml.Query;
import com.alibaba.schedulerx.shade.org.h2.engine.GeneratedKeys;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Comparison;
import com.alibaba.schedulerx.shade.org.h2.expression.Condition;
import com.alibaba.schedulerx.shade.org.h2.expression.ConditionAndOr;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.schedulerx.shade.org.h2.expression.Parameter;
import com.alibaba.schedulerx.shade.org.h2.expression.SequenceValue;
import com.alibaba.schedulerx.shade.org.h2.index.Index;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.mvstore.db.MVPrimaryIndex;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.result.ResultTarget;
import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.util.ArrayList;
import java.util.HashMap;

public class Insert
extends Prepared
implements ResultTarget {
    private Table table;
    private Column[] columns;
    private final ArrayList<Expression[]> list = New.arrayList();
    private Query query;
    private boolean sortedInsertMode;
    private int rowNumber;
    private boolean insertFromSelect;
    private TableFilter sourceTableFilter;
    private HashMap<Column, Expression> duplicateKeyAssignmentMap;
    private boolean ignore;

    public Insert(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setIgnore(boolean bl) {
        this.ignore = bl;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addAssignmentForDuplicate(Column column, Expression expression) {
        if (this.duplicateKeyAssignmentMap == null) {
            this.duplicateKeyAssignmentMap = new HashMap();
        }
        if (this.duplicateKeyAssignmentMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.duplicateKeyAssignmentMap.put(column, expression);
    }

    public void addRow(Expression[] expressionArray) {
        this.list.add(expressionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Index index2 = null;
        if (this.sortedInsertMode) {
            index2 = this.table.getScanIndex(this.session);
            index2.setSortedInsertMode(true);
        }
        try {
            int n = this.insertRows();
            return n;
        }
        finally {
            if (index2 != null) {
                index2.setSortedInsertMode(false);
            }
        }
    }

    private int insertRows() {
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0);
        this.table.fire(this.session, 1, true);
        this.rowNumber = 0;
        GeneratedKeys generatedKeys = this.session.getGeneratedKeys();
        generatedKeys.initialize(this.table);
        int n = this.list.size();
        if (n > 0) {
            int n2 = this.columns.length;
            for (int i = 0; i < n; ++i) {
                Row row;
                block11: {
                    int n3;
                    this.session.startStatementWithinTransaction();
                    generatedKeys.nextRow();
                    row = this.table.getTemplateRow();
                    Expression[] expressionArray = this.list.get(i);
                    this.setCurrentRowNumber(i + 1);
                    for (n3 = 0; n3 < n2; ++n3) {
                        Column column = this.columns[n3];
                        int n4 = column.getColumnId();
                        Expression expression = expressionArray[n3];
                        if (expression == null) continue;
                        expression = expression.optimize(this.session);
                        try {
                            Value value2 = column.convert(expression.getValue(this.session), this.session.getDatabase().getMode());
                            row.setValue(n4, value2);
                            if (!(expression instanceof SequenceValue)) continue;
                            generatedKeys.add(column);
                            continue;
                        }
                        catch (DbException dbException) {
                            throw this.setRow(dbException, i, Insert.getSQL(expressionArray));
                        }
                    }
                    ++this.rowNumber;
                    this.table.validateConvertUpdateSequence(this.session, row);
                    n3 = this.table.fireBeforeRow(this.session, null, row) ? 1 : 0;
                    if (n3 != 0) continue;
                    this.table.lock(this.session, true, false);
                    try {
                        this.table.addRow(this.session, row);
                    }
                    catch (DbException dbException) {
                        if (this.handleOnDuplicate(dbException)) break block11;
                        --this.rowNumber;
                        continue;
                    }
                }
                generatedKeys.confirmRow(row);
                this.session.log(this.table, (short)0, row);
                this.table.fireAfterRow(this.session, null, row, false);
            }
        } else {
            this.table.lock(this.session, true, false);
            if (this.insertFromSelect) {
                this.query.query(0, this);
            } else {
                ResultInterface resultInterface = this.query.query(0);
                while (resultInterface.next()) {
                    generatedKeys.nextRow();
                    Value[] valueArray = resultInterface.currentRow();
                    Row row = this.addRowImpl(valueArray);
                    if (row == null) continue;
                    generatedKeys.confirmRow(row);
                }
                resultInterface.close();
            }
        }
        this.table.fire(this.session, 1, false);
        return this.rowNumber;
    }

    @Override
    public void addRow(Value[] valueArray) {
        this.addRowImpl(valueArray);
    }

    private Row addRowImpl(Value[] valueArray) {
        int n;
        Row row = this.table.getTemplateRow();
        this.setCurrentRowNumber(++this.rowNumber);
        int n2 = this.columns.length;
        for (n = 0; n < n2; ++n) {
            Column column = this.columns[n];
            int n3 = column.getColumnId();
            try {
                Value value2 = column.convert(valueArray[n], this.session.getDatabase().getMode());
                row.setValue(n3, value2);
                continue;
            }
            catch (DbException dbException) {
                throw this.setRow(dbException, this.rowNumber, Insert.getSQL(valueArray));
            }
        }
        this.table.validateConvertUpdateSequence(this.session, row);
        n = this.table.fireBeforeRow(this.session, null, row) ? 1 : 0;
        if (n == 0) {
            this.table.addRow(this.session, row);
            this.session.log(this.table, (short)0, row);
            this.table.fireAfterRow(this.session, null, row, false);
            return row;
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.rowNumber;
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
        statementBuilder.append(this.table.getSQL()).append('(');
        for (Column expressionArray : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expressionArray.getSQL());
        }
        statementBuilder.append(")\n");
        if (this.insertFromSelect) {
            statementBuilder.append("DIRECT ");
        }
        if (this.sortedInsertMode) {
            statementBuilder.append("SORTED ");
        }
        if (!this.list.isEmpty()) {
            statementBuilder.append("VALUES ");
            int n = 0;
            if (this.list.size() > 1) {
                statementBuilder.append('\n');
            }
            for (Expression[] expressionArray : this.list) {
                if (n++ > 0) {
                    statementBuilder.append(",\n");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (Expression expression : expressionArray) {
                    statementBuilder.appendExceptFirst(", ");
                    if (expression == null) {
                        statementBuilder.append("DEFAULT");
                        continue;
                    }
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
            }
        } else {
            statementBuilder.append(this.query.getPlanSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.columns == null) {
            this.columns = !this.list.isEmpty() && this.list.get(0).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (!this.list.isEmpty()) {
            for (Expression[] expressionArray : this.list) {
                if (expressionArray.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                int n = expressionArray.length;
                for (int i = 0; i < n; ++i) {
                    Expression expression = expressionArray[i];
                    if (expression == null) continue;
                    if (this.sourceTableFilter != null) {
                        expression.mapColumns(this.sourceTableFilter, 0);
                    }
                    if ((expression = expression.optimize(this.session)) instanceof Parameter) {
                        Parameter parameter = (Parameter)expression;
                        parameter.setColumn(this.columns[i]);
                    }
                    expressionArray[i] = expression;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setSortedInsertMode(boolean bl) {
        this.sortedInsertMode = bl;
    }

    @Override
    public int getType() {
        return 61;
    }

    public void setInsertFromSelect(boolean bl) {
        this.insertFromSelect = bl;
    }

    @Override
    public boolean isCacheable() {
        return this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty();
    }

    private boolean handleOnDuplicate(DbException dbException) {
        Object object;
        Object object3;
        if (dbException.getErrorCode() != 23505) {
            throw dbException;
        }
        if (this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty()) {
            if (this.ignore) {
                return false;
            }
            throw dbException;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.duplicateKeyAssignmentMap.size());
        Expression[] expressionArray = this.list.get(this.getCurrentRowNumber() - 1);
        for (int i = 0; i < this.columns.length; ++i) {
            object3 = this.table.getSchema().getName() + "." + this.table.getName() + "." + this.columns[i].getName();
            arrayList.add(object3);
            this.session.setVariable((String)object3, expressionArray[i].getValue(this.session));
        }
        StatementBuilder statementBuilder = new StatementBuilder("UPDATE ");
        statementBuilder.append(this.table.getSQL()).append(" SET ");
        for (Column object22 : this.duplicateKeyAssignmentMap.keySet()) {
            statementBuilder.appendExceptFirst(", ");
            object = this.duplicateKeyAssignmentMap.get(object22);
            statementBuilder.append(object22.getSQL()).append("=").append(((Expression)object).getSQL());
        }
        statementBuilder.append(" WHERE ");
        object3 = (Index)dbException.getSource();
        if (object3 == null) {
            throw DbException.getUnsupportedException("Unable to apply ON DUPLICATE KEY UPDATE, no index found!");
        }
        statementBuilder.append(this.prepareUpdateCondition((Index)object3).getSQL());
        String string2 = statementBuilder.toString();
        object = this.session.prepare(string2);
        for (Parameter parameter : ((Prepared)object).getParameters()) {
            Parameter parameter2 = (Parameter)this.parameters.get(parameter.getIndex());
            parameter.setValue(parameter2.getValue(this.session));
        }
        ((Prepared)object).update();
        for (String string3 : arrayList) {
            this.session.setVariable(string3, ValueNull.INSTANCE);
        }
        return true;
    }

    private Expression prepareUpdateCondition(Index index2) {
        Column[] columnArray;
        Expression[] expressionArray;
        if (index2 instanceof MVPrimaryIndex) {
            expressionArray = (Expression[])index2;
            columnArray = new Column[]{expressionArray.getIndexColumns()[expressionArray.getMainIndexColumn()].column};
        } else {
            columnArray = index2.getColumns();
        }
        expressionArray = this.list.get(this.getCurrentRowNumber() - 1);
        Condition condition = null;
        block0: for (Column column : columnArray) {
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), this.table.getSchema().getName(), this.table.getName(), column.getName());
            for (int i = 0; i < this.columns.length; ++i) {
                if (!expressionColumn.getColumnName().equals(this.columns[i].getName())) continue;
                if (condition == null) {
                    condition = new Comparison(this.session, 0, expressionColumn, expressionArray[i]);
                    continue block0;
                }
                condition = new ConditionAndOr(0, condition, new Comparison(this.session, 0, expressionColumn, expressionArray[i]));
                continue block0;
            }
        }
        return condition;
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }
}

