/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.dml;

import com.alibaba.schedulerx.shade.org.h2.command.dml.Query;
import com.alibaba.schedulerx.shade.org.h2.command.dml.SelectOrderBy;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.schedulerx.shade.org.h2.expression.Parameter;
import com.alibaba.schedulerx.shade.org.h2.expression.ValueExpression;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.result.LazyResult;
import com.alibaba.schedulerx.shade.org.h2.result.LocalResult;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.result.ResultTarget;
import com.alibaba.schedulerx.shade.org.h2.result.SortOrder;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.ColumnResolver;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.ColumnNamer;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueInt;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.util.ArrayList;
import java.util.HashSet;

public class SelectUnion
extends Query {
    private UnionType unionType;
    final Query left;
    Query right;
    private ArrayList<Expression> expressions;
    private Expression[] expressionArray;
    private ArrayList<SelectOrderBy> orderList;
    private SortOrder sort;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean isForUpdate;

    public SelectUnion(Session session, Query query) {
        super(session);
        this.left = query;
    }

    @Override
    public boolean isUnion() {
        return true;
    }

    @Override
    public void prepareJoinBatch() {
        this.left.prepareJoinBatch();
        this.right.prepareJoinBatch();
    }

    public void setUnionType(UnionType unionType) {
        this.unionType = unionType;
    }

    public UnionType getUnionType() {
        return this.unionType;
    }

    public void setRight(Query query) {
        this.right = query;
    }

    public Query getLeft() {
        return this.left;
    }

    public Query getRight() {
        return this.right;
    }

    @Override
    public void setSQL(String string2) {
        this.sqlStatement = string2;
    }

    @Override
    public void setOrder(ArrayList<SelectOrderBy> arrayList) {
        this.orderList = arrayList;
    }

    @Override
    public boolean hasOrder() {
        return this.orderList != null || this.sort != null;
    }

    private Value[] convert(Value[] valueArray, int n) {
        Value[] valueArray2 = n == valueArray.length ? valueArray : new Value[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = this.expressions.get(i);
            valueArray2[i] = valueArray[i].convertTo(expression.getType());
        }
        return valueArray2;
    }

    @Override
    public ResultInterface queryMeta() {
        int n = this.left.getColumnCount();
        LocalResult localResult = new LocalResult(this.session, this.expressionArray, n);
        localResult.done();
        return localResult;
    }

    public LocalResult getEmptyResult() {
        int n = this.left.getColumnCount();
        return new LocalResult(this.session, this.expressionArray, n);
    }

    @Override
    protected ResultInterface queryWithoutCache(int n, ResultTarget resultTarget) {
        Object object;
        Object object2;
        int n2;
        Object object3;
        if (n != 0) {
            n2 = this.limitExpr == null ? -1 : ((object3 = this.limitExpr.getValue(this.session)) == ValueNull.INSTANCE ? -1 : ((Value)object3).getInt());
            n2 = n2 < 0 ? n : Math.min(n2, n);
            this.limitExpr = ValueExpression.get(ValueInt.get(n2));
        }
        if (this.session.getDatabase().getSettings().optimizeInsertFromSelect && this.unionType == UnionType.UNION_ALL && resultTarget != null && this.sort == null && !this.distinct && n == 0 && this.offsetExpr == null && this.limitExpr == null) {
            this.left.query(0, resultTarget);
            this.right.query(0, resultTarget);
            return null;
        }
        n2 = this.left.getColumnCount();
        if (this.session.isLazyQueryExecution() && this.unionType == UnionType.UNION_ALL && !this.distinct && this.sort == null && !this.randomAccessResult && !this.isForUpdate && this.offsetExpr == null && this.isReadOnly()) {
            int n3 = -1;
            if (this.limitExpr != null && (object2 = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
                n3 = ((Value)object2).getInt();
            }
            if (n3 != 0) {
                object2 = new LazyResultUnion(this.expressionArray, n2);
                if (n3 > 0) {
                    ((LazyResult)object2).setLimit(n3);
                }
                return object2;
            }
        }
        object3 = new LocalResult(this.session, this.expressionArray, n2);
        if (this.sort != null) {
            ((LocalResult)object3).setSortOrder(this.sort);
        }
        if (this.distinct) {
            this.left.setDistinct(true);
            this.right.setDistinct(true);
            ((LocalResult)object3).setDistinct();
        }
        if (this.randomAccessResult) {
            ((LocalResult)object3).setRandomAccess();
        }
        switch (this.unionType) {
            case UNION: 
            case EXCEPT: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                ((LocalResult)object3).setDistinct();
                break;
            }
            case UNION_ALL: {
                break;
            }
            case INTERSECT: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        object2 = this.left.query(0);
        ResultInterface resultInterface = this.right.query(0);
        object2.reset();
        resultInterface.reset();
        switch (this.unionType) {
            case UNION: 
            case UNION_ALL: {
                while (object2.next()) {
                    ((LocalResult)object3).addRow(this.convert(object2.currentRow(), n2));
                }
                while (resultInterface.next()) {
                    ((LocalResult)object3).addRow(this.convert(resultInterface.currentRow(), n2));
                }
                break;
            }
            case EXCEPT: {
                while (object2.next()) {
                    ((LocalResult)object3).addRow(this.convert(object2.currentRow(), n2));
                }
                while (resultInterface.next()) {
                    ((LocalResult)object3).removeDistinct(this.convert(resultInterface.currentRow(), n2));
                }
                break;
            }
            case INTERSECT: {
                object = new LocalResult(this.session, this.expressionArray, n2);
                ((LocalResult)object).setDistinct();
                ((LocalResult)object).setRandomAccess();
                while (object2.next()) {
                    ((LocalResult)object).addRow(this.convert(object2.currentRow(), n2));
                }
                while (resultInterface.next()) {
                    Value[] valueArray = this.convert(resultInterface.currentRow(), n2);
                    if (!((LocalResult)object).containsDistinct(valueArray)) continue;
                    ((LocalResult)object3).addRow(valueArray);
                }
                ((LocalResult)object).close();
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        if (this.offsetExpr != null) {
            ((LocalResult)object3).setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (this.limitExpr != null && (object = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            ((LocalResult)object3).setLimit(((Value)object).getInt());
        }
        object2.close();
        resultInterface.close();
        ((LocalResult)object3).done();
        if (resultTarget != null) {
            while (((LocalResult)object3).next()) {
                resultTarget.addRow(((LocalResult)object3).currentRow());
            }
            ((LocalResult)object3).close();
            return null;
        }
        return object3;
    }

    @Override
    public void init() {
        if (SysProperties.CHECK && this.checkInit) {
            DbException.throwInternalError();
        }
        this.checkInit = true;
        this.left.init();
        this.right.init();
        int n = this.left.getColumnCount();
        if (n != this.right.getColumnCount()) {
            throw DbException.get(21002);
        }
        ArrayList<Expression> arrayList = this.left.getExpressions();
        this.expressions = New.arrayList();
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            this.expressions.add(expression);
        }
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        this.isPrepared = true;
        this.left.prepare();
        this.right.prepare();
        int n = this.left.getColumnCount();
        this.expressions = New.arrayList();
        ArrayList<Expression> arrayList = this.left.getExpressions();
        ArrayList<Expression> arrayList2 = this.right.getExpressions();
        ColumnNamer columnNamer = new ColumnNamer(this.session);
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            Expression expression2 = arrayList2.get(i);
            int n2 = Value.getHigherOrder(expression.getType(), expression2.getType());
            long l = Math.max(expression.getPrecision(), expression2.getPrecision());
            int n3 = Math.max(expression.getScale(), expression2.getScale());
            int n4 = Math.max(expression.getDisplaySize(), expression2.getDisplaySize());
            String string2 = columnNamer.getColumnName(expression, i, expression.getAlias());
            Column column = new Column(string2, n2, l, n3, n4);
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), column);
            this.expressions.add(expressionColumn);
        }
        if (this.orderList != null) {
            SelectUnion.initOrder(this.session, this.expressions, null, this.orderList, this.getColumnCount(), true, null);
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        this.expressionArray = this.expressions.toArray(new Expression[0]);
    }

    @Override
    public double getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = this.left.getTables();
        hashSet.addAll(this.right.getTables());
        return hashSet;
    }

    @Override
    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void setForUpdate(boolean bl) {
        this.left.setForUpdate(bl);
        this.right.setForUpdate(bl);
        this.isForUpdate = bl;
    }

    @Override
    public int getColumnCount() {
        return this.left.getColumnCount();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.right.mapColumns(columnResolver, n);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n, int n2) {
        this.addParameter(parameter);
        switch (this.unionType) {
            case UNION: 
            case UNION_ALL: 
            case INTERSECT: {
                this.left.addGlobalCondition(parameter, n, n2);
                this.right.addGlobalCondition(parameter, n, n2);
                break;
            }
            case EXCEPT: {
                this.left.addGlobalCondition(parameter, n, n2);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
    }

    @Override
    public String getPlanSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.left.getPlanSQL()).append(')');
        switch (this.unionType) {
            case UNION_ALL: {
                stringBuilder.append("\nUNION ALL\n");
                break;
            }
            case UNION: {
                stringBuilder.append("\nUNION\n");
                break;
            }
            case INTERSECT: {
                stringBuilder.append("\nINTERSECT\n");
                break;
            }
            case EXCEPT: {
                stringBuilder.append("\nEXCEPT\n");
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.unionType));
            }
        }
        stringBuilder.append('(').append(this.right.getPlanSQL()).append(')');
        Expression[] expressionArray = this.expressions.toArray(new Expression[0]);
        if (this.sort != null) {
            stringBuilder.append("\nORDER BY ").append(this.sort.getSQL(expressionArray, expressionArray.length));
        }
        if (this.limitExpr != null) {
            stringBuilder.append("\nLIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
            if (this.offsetExpr != null) {
                stringBuilder.append("\nOFFSET ").append(StringUtils.unEnclose(this.offsetExpr.getSQL()));
            }
        }
        if (this.sampleSizeExpr != null) {
            stringBuilder.append("\nSAMPLE_SIZE ").append(StringUtils.unEnclose(this.sampleSizeExpr.getSQL()));
        }
        if (this.isForUpdate) {
            stringBuilder.append("\nFOR UPDATE");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public boolean isReadOnly() {
        return this.left.isReadOnly() && this.right.isReadOnly();
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
    }

    @Override
    public void fireBeforeSelectTriggers() {
        this.left.fireBeforeSelectTriggers();
        this.right.fireBeforeSelectTriggers();
    }

    @Override
    public int getType() {
        return 66;
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.left.allowGlobalConditions() && this.right.allowGlobalConditions();
    }

    private final class LazyResultUnion
    extends LazyResult {
        int columnCount;
        ResultInterface l;
        ResultInterface r;
        boolean leftDone;
        boolean rightDone;

        LazyResultUnion(Expression[] expressionArray, int n) {
            super(expressionArray);
            this.columnCount = n;
        }

        @Override
        public int getVisibleColumnCount() {
            return this.columnCount;
        }

        @Override
        protected Value[] fetchNextRow() {
            if (this.rightDone) {
                return null;
            }
            if (!this.leftDone) {
                if (this.l == null) {
                    this.l = SelectUnion.this.left.query(0);
                    this.l.reset();
                }
                if (this.l.next()) {
                    return this.l.currentRow();
                }
                this.leftDone = true;
            }
            if (this.r == null) {
                this.r = SelectUnion.this.right.query(0);
                this.r.reset();
            }
            if (this.r.next()) {
                return this.r.currentRow();
            }
            this.rightDone = true;
            return null;
        }

        @Override
        public void close() {
            super.close();
            if (this.l != null) {
                this.l.close();
            }
            if (this.r != null) {
                this.r.close();
            }
        }

        @Override
        public void reset() {
            super.reset();
            if (this.l != null) {
                this.l.reset();
            }
            if (this.r != null) {
                this.r.reset();
            }
            this.leftDone = false;
            this.rightDone = false;
        }
    }

    public static enum UnionType {
        UNION,
        UNION_ALL,
        EXCEPT,
        INTERSECT;

    }
}

