/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.engine;

import com.alibaba.schedulerx.shade.org.h2.command.dml.SetTypes;
import com.alibaba.schedulerx.shade.org.h2.engine.DbSettings;
import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.security.SHA256;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FilePathEncrypt;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FilePathRec;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileUtils;
import com.alibaba.schedulerx.shade.org.h2.util.SortedProperties;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;

public class ConnectionInfo
implements Cloneable {
    private static final HashSet<String> KNOWN_SETTINGS;
    private Properties prop = new Properties();
    private String originalURL;
    private String url;
    private String user;
    private byte[] filePasswordHash;
    private byte[] fileEncryptionKey;
    private byte[] userPasswordHash;
    private String name;
    private String nameNormalized;
    private boolean remote;
    private boolean ssl;
    private boolean persistent;
    private boolean unnamed;

    public ConnectionInfo(String string2) {
        this.name = string2;
        this.url = "jdbc:h2:" + string2;
        this.parseName();
    }

    public ConnectionInfo(String string2, Properties properties) {
        this.originalURL = string2 = ConnectionInfo.remapURL(string2);
        if (!string2.startsWith("jdbc:h2:")) {
            throw DbException.getInvalidValueException("url", string2);
        }
        this.url = string2;
        this.readProperties(properties);
        this.readSettingsFromURL();
        this.setUserName(this.removeProperty("USER", ""));
        this.convertPasswords();
        this.name = this.url.substring("jdbc:h2:".length());
        this.parseName();
        String string3 = this.removeProperty("RECOVER_TEST", null);
        if (string3 != null) {
            FilePathRec.register();
            try {
                Utils.callStaticMethod("com.alibaba.schedulerx.shade.org.h2.store.RecoverTester.init", string3);
            }
            catch (Exception exception) {
                throw DbException.convert(exception);
            }
            this.name = "rec:" + this.name;
        }
    }

    private static boolean isKnownSetting(String string2) {
        return KNOWN_SETTINGS.contains(string2);
    }

    public ConnectionInfo clone() throws CloneNotSupportedException {
        ConnectionInfo connectionInfo = (ConnectionInfo)super.clone();
        connectionInfo.prop = (Properties)this.prop.clone();
        connectionInfo.filePasswordHash = Utils.cloneByteArray(this.filePasswordHash);
        connectionInfo.fileEncryptionKey = Utils.cloneByteArray(this.fileEncryptionKey);
        connectionInfo.userPasswordHash = Utils.cloneByteArray(this.userPasswordHash);
        return connectionInfo;
    }

    private void parseName() {
        if (".".equals(this.name)) {
            this.name = "mem:";
        }
        if (this.name.startsWith("tcp:")) {
            this.remote = true;
            this.name = this.name.substring("tcp:".length());
        } else if (this.name.startsWith("ssl:")) {
            this.remote = true;
            this.ssl = true;
            this.name = this.name.substring("ssl:".length());
        } else if (this.name.startsWith("mem:")) {
            this.persistent = false;
            if ("mem:".equals(this.name)) {
                this.unnamed = true;
            }
        } else if (this.name.startsWith("file:")) {
            this.name = this.name.substring("file:".length());
            this.persistent = true;
        } else {
            this.persistent = true;
        }
        if (this.persistent && !this.remote) {
            this.name = "/".equals(SysProperties.FILE_SEPARATOR) ? this.name.replace('\\', '/') : this.name.replace('/', '\\');
        }
    }

    public void setBaseDir(String string2) {
        if (this.persistent) {
            String string3;
            String string4 = FileUtils.unwrap(FileUtils.toRealPath(string2));
            boolean bl = FileUtils.isAbsolute(this.name);
            String string5 = null;
            if (string2.endsWith(SysProperties.FILE_SEPARATOR)) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (bl) {
                string3 = this.name;
            } else {
                string3 = FileUtils.unwrap(this.name);
                string5 = this.name.substring(0, this.name.length() - string3.length());
                string3 = string2 + SysProperties.FILE_SEPARATOR + string3;
            }
            String string6 = FileUtils.unwrap(FileUtils.toRealPath(string3));
            if (string6.equals(string4) || !string6.startsWith(string4)) {
                throw DbException.get(90028, string6 + " outside " + string4);
            }
            if (!string4.endsWith("/") && !string4.endsWith("\\") && string6.charAt(string4.length()) != '/') {
                throw DbException.get(90028, string6 + " outside " + string4);
            }
            if (!bl) {
                this.name = string5 + string2 + SysProperties.FILE_SEPARATOR + FileUtils.unwrap(this.name);
            }
        }
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    boolean isUnnamedInMemory() {
        return this.unnamed;
    }

    private void readProperties(Properties properties) {
        Object[] objectArray = properties.keySet().toArray();
        DbSettings dbSettings = null;
        for (Object object : objectArray) {
            String string2 = StringUtils.toUpperEnglish(object.toString());
            if (this.prop.containsKey(string2)) {
                throw DbException.get(90066, string2);
            }
            Object object2 = properties.get(object);
            if (ConnectionInfo.isKnownSetting(string2)) {
                this.prop.put(string2, object2);
                continue;
            }
            if (dbSettings == null) {
                dbSettings = this.getDbSettings();
            }
            if (!dbSettings.containsKey(string2)) continue;
            this.prop.put(string2, object2);
        }
    }

    private void readSettingsFromURL() {
        DbSettings dbSettings = DbSettings.getDefaultSettings();
        int n = this.url.indexOf(59);
        if (n >= 0) {
            String[] stringArray;
            String string2 = this.url.substring(n + 1);
            this.url = this.url.substring(0, n);
            for (String string3 : stringArray = StringUtils.arraySplit(string2, ';', false)) {
                if (string3.length() == 0) continue;
                int n2 = string3.indexOf(61);
                if (n2 < 0) {
                    throw this.getFormatException();
                }
                String string4 = string3.substring(n2 + 1);
                String string5 = string3.substring(0, n2);
                if (!ConnectionInfo.isKnownSetting(string5 = StringUtils.toUpperEnglish(string5)) && !dbSettings.containsKey(string5)) {
                    throw DbException.get(90113, string5);
                }
                String string6 = this.prop.getProperty(string5);
                if (string6 != null && !string6.equals(string4)) {
                    throw DbException.get(90066, string5);
                }
                this.prop.setProperty(string5, string4);
            }
        }
    }

    private char[] removePassword() {
        Object object = this.prop.remove("PASSWORD");
        if (object == null) {
            return new char[0];
        }
        if (object instanceof char[]) {
            return (char[])object;
        }
        return object.toString().toCharArray();
    }

    private void convertPasswords() {
        char[] cArray = this.removePassword();
        boolean bl = this.removeProperty("PASSWORD_HASH", false);
        if (this.getProperty("CIPHER", null) != null) {
            int n = -1;
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                if (cArray[i] != ' ') continue;
                n = i;
                break;
            }
            if (n < 0) {
                throw DbException.get(90050);
            }
            char[] cArray2 = Arrays.copyOfRange(cArray, n + 1, cArray.length);
            char[] cArray3 = Arrays.copyOf(cArray, n);
            Arrays.fill(cArray, '\u0000');
            cArray = cArray2;
            this.fileEncryptionKey = FilePathEncrypt.getPasswordBytes(cArray3);
            this.filePasswordHash = ConnectionInfo.hashPassword(bl, "file", cArray3);
        }
        this.userPasswordHash = ConnectionInfo.hashPassword(bl, this.user, cArray);
    }

    private static byte[] hashPassword(boolean bl, String string2, char[] cArray) {
        if (bl) {
            return StringUtils.convertHexToBytes(new String(cArray));
        }
        if (string2.length() == 0 && cArray.length == 0) {
            return new byte[0];
        }
        return SHA256.getKeyPasswordHash(string2, cArray);
    }

    public boolean getProperty(String string2, boolean bl) {
        return Utils.parseBoolean(this.getProperty(string2, null), bl, false);
    }

    public boolean removeProperty(String string2, boolean bl) {
        return Utils.parseBoolean(this.removeProperty(string2, null), bl, false);
    }

    String removeProperty(String string2, String string3) {
        Object object;
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(string2)) {
            DbException.throwInternalError(string2);
        }
        return (object = this.prop.remove(string2)) == null ? string3 : object.toString();
    }

    public String getName() {
        if (!this.persistent) {
            return this.name;
        }
        if (this.nameNormalized == null) {
            String string2;
            if (!(SysProperties.IMPLICIT_RELATIVE_PATH || FileUtils.isAbsolute(this.name) || this.name.contains("./") || this.name.contains(".\\") || this.name.contains(":/") || this.name.contains(":\\"))) {
                throw DbException.get(90011, this.originalURL);
            }
            String string3 = ".h2.db";
            if (FileUtils.exists(this.name + string3)) {
                string2 = FileUtils.toRealPath(this.name + string3);
            } else {
                string3 = ".mv.db";
                string2 = FileUtils.toRealPath(this.name + string3);
            }
            String string4 = FileUtils.getName(string2);
            if (string4.length() < string3.length() + 1) {
                throw DbException.get(90138, this.name);
            }
            this.nameNormalized = string2.substring(0, string2.length() - string3.length());
        }
        return this.nameNormalized;
    }

    public byte[] getFilePasswordHash() {
        return this.filePasswordHash;
    }

    byte[] getFileEncryptionKey() {
        return this.fileEncryptionKey;
    }

    public String getUserName() {
        return this.user;
    }

    byte[] getUserPasswordHash() {
        return this.userPasswordHash;
    }

    String[] getKeys() {
        return this.prop.keySet().toArray(new String[this.prop.size()]);
    }

    String getProperty(String string2) {
        Object object = this.prop.get(string2);
        if (!(object instanceof String)) {
            return null;
        }
        return object.toString();
    }

    int getProperty(String string2, int n) {
        String string3;
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(string2)) {
            DbException.throwInternalError(string2);
        }
        return (string3 = this.getProperty(string2)) == null ? n : Integer.parseInt(string3);
    }

    public String getProperty(String string2, String string3) {
        String string4;
        if (SysProperties.CHECK && !ConnectionInfo.isKnownSetting(string2)) {
            DbException.throwInternalError(string2);
        }
        return (string4 = this.getProperty(string2)) == null ? string3 : string4;
    }

    String getProperty(int n, String string2) {
        String string3 = SetTypes.getTypeName(n);
        String string4 = this.getProperty(string3);
        return string4 == null ? string2 : string4;
    }

    int getIntProperty(int n, int n2) {
        String string2 = SetTypes.getTypeName(n);
        String string3 = this.getProperty(string2, null);
        try {
            return string3 == null ? n2 : Integer.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    boolean isSSL() {
        return this.ssl;
    }

    public void setUserName(String string2) {
        this.user = StringUtils.toUpperEnglish(string2);
    }

    public void setUserPasswordHash(byte[] byArray) {
        this.userPasswordHash = byArray;
    }

    public void setFilePasswordHash(byte[] byArray) {
        this.filePasswordHash = byArray;
    }

    public void setFileEncryptionKey(byte[] byArray) {
        this.fileEncryptionKey = byArray;
    }

    public void setProperty(String string2, String string3) {
        if (string3 != null) {
            this.prop.setProperty(string2, string3);
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getOriginalURL() {
        return this.originalURL;
    }

    public void setOriginalURL(String string2) {
        this.originalURL = string2;
    }

    DbException getFormatException() {
        String string2 = "jdbc:h2:{ {.|mem:}[name] | [file:]fileName | {tcp|ssl}:[//]server[:port][,server2[:port]]/name }[;key=value...]";
        return DbException.get(90046, string2, this.url);
    }

    public void setServerKey(String string2) {
        this.remote = true;
        this.persistent = false;
        this.name = string2;
    }

    public DbSettings getDbSettings() {
        DbSettings dbSettings = DbSettings.getDefaultSettings();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object : this.prop.keySet()) {
            String string2 = object.toString();
            if (ConnectionInfo.isKnownSetting(string2) || !dbSettings.containsKey(string2)) continue;
            hashMap.put(string2, this.prop.getProperty(string2));
        }
        return DbSettings.getInstance(hashMap);
    }

    private static String remapURL(String string2) {
        String string3 = SysProperties.URL_MAP;
        if (string3 != null && string3.length() > 0) {
            try {
                SortedProperties sortedProperties = SortedProperties.loadProperties(string3);
                String string4 = sortedProperties.getProperty(string2);
                if (string4 == null) {
                    sortedProperties.put(string2, "");
                    sortedProperties.store(string3);
                } else if ((string4 = string4.trim()).length() > 0) {
                    return string4;
                }
            }
            catch (IOException iOException) {
                throw DbException.convert(iOException);
            }
        }
        return string2;
    }

    static {
        ArrayList<String> arrayList = SetTypes.getTypes();
        String[] stringArray = new String[]{"ACCESS_MODE_DATA", "AUTOCOMMIT", "CIPHER", "CREATE", "CACHE_TYPE", "FILE_LOCK", "IGNORE_UNKNOWN_SETTINGS", "IFEXISTS", "INIT", "PASSWORD", "RECOVER", "RECOVER_TEST", "USER", "AUTO_SERVER", "AUTO_SERVER_PORT", "NO_UPGRADE", "AUTO_RECONNECT", "OPEN_NEW", "PAGE_SIZE", "PASSWORD_HASH", "JMX", "SCOPE_GENERATED_KEYS"};
        HashSet<String> hashSet = new HashSet<String>(arrayList.size() + stringArray.length);
        hashSet.addAll(arrayList);
        for (String string2 : stringArray) {
            if (hashSet.add(string2) || !SysProperties.CHECK) continue;
            DbException.throwInternalError(string2);
        }
        KNOWN_SETTINGS = hashSet;
    }
}

