/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.expression;

import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.expression.Aggregate;
import com.alibaba.schedulerx.shade.org.h2.expression.AggregateData;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.util.ValueHashMap;
import com.alibaba.schedulerx.shade.org.h2.value.DataType;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueBoolean;
import com.alibaba.schedulerx.shade.org.h2.value.ValueDouble;
import com.alibaba.schedulerx.shade.org.h2.value.ValueLong;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;

class AggregateDataDefault
extends AggregateData {
    private final Aggregate.AggregateType aggregateType;
    private long count;
    private ValueHashMap<AggregateDataDefault> distinctValues;
    private Value value;
    private double m2;
    private double mean;

    AggregateDataDefault(Aggregate.AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    @Override
    void add(Database database, int n, boolean bl, Value value2) {
        if (value2 == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        if (bl) {
            if (this.distinctValues == null) {
                this.distinctValues = ValueHashMap.newInstance();
            }
            this.distinctValues.put(value2, this);
            return;
        }
        switch (this.aggregateType) {
            case SUM: {
                if (this.value == null) {
                    this.value = value2.convertTo(n);
                    break;
                }
                value2 = value2.convertTo(this.value.getType());
                this.value = this.value.add(value2);
                break;
            }
            case AVG: {
                if (this.value == null) {
                    this.value = value2.convertTo(DataType.getAddProofType(n));
                    break;
                }
                value2 = value2.convertTo(this.value.getType());
                this.value = this.value.add(value2);
                break;
            }
            case MIN: {
                if (this.value != null && database.compare(value2, this.value) >= 0) break;
                this.value = value2;
                break;
            }
            case MAX: {
                if (this.value != null && database.compare(value2, this.value) <= 0) break;
                this.value = value2;
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                double d = value2.getDouble();
                if (this.count == 1L) {
                    this.mean = d;
                    this.m2 = 0.0;
                    break;
                }
                double d2 = d - this.mean;
                this.mean += d2 / (double)this.count;
                this.m2 += d2 * (d - this.mean);
                break;
            }
            case BOOL_AND: {
                value2 = value2.convertTo(1);
                if (this.value == null) {
                    this.value = value2;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() && value2.getBoolean());
                break;
            }
            case BOOL_OR: {
                value2 = value2.convertTo(1);
                if (this.value == null) {
                    this.value = value2;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() || value2.getBoolean());
                break;
            }
            case BIT_AND: {
                if (this.value == null) {
                    this.value = value2.convertTo(n);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() & value2.getLong()).convertTo(n);
                break;
            }
            case BIT_OR: {
                if (this.value == null) {
                    this.value = value2.convertTo(n);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() | value2.getLong()).convertTo(n);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
    }

    @Override
    Value getValue(Database database, int n, boolean bl) {
        if (bl) {
            this.count = 0L;
            this.groupDistinct(database, n);
        }
        Value value2 = null;
        switch (this.aggregateType) {
            case SUM: 
            case MIN: 
            case MAX: 
            case BOOL_AND: 
            case BOOL_OR: 
            case BIT_AND: 
            case BIT_OR: {
                value2 = this.value;
                break;
            }
            case AVG: {
                if (this.value == null) break;
                value2 = AggregateDataDefault.divide(this.value, this.count);
                break;
            }
            case STDDEV_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value2 = ValueDouble.get(Math.sqrt(this.m2 / (double)this.count));
                break;
            }
            case STDDEV_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value2 = ValueDouble.get(Math.sqrt(this.m2 / (double)(this.count - 1L)));
                break;
            }
            case VAR_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value2 = ValueDouble.get(this.m2 / (double)this.count);
                break;
            }
            case VAR_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value2 = ValueDouble.get(this.m2 / (double)(this.count - 1L));
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return value2 == null ? ValueNull.INSTANCE : value2.convertTo(n);
    }

    private static Value divide(Value value2, long l) {
        if (l == 0L) {
            return ValueNull.INSTANCE;
        }
        int n = Value.getHigherOrder(value2.getType(), 5);
        Value value3 = ValueLong.get(l).convertTo(n);
        value2 = value2.convertTo(n).divide(value3);
        return value2;
    }

    private void groupDistinct(Database database, int n) {
        if (this.distinctValues == null) {
            return;
        }
        this.count = 0L;
        for (Value value2 : this.distinctValues.keys()) {
            this.add(database, n, false, value2);
        }
    }
}

