/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.expression;

import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Comparison;
import com.alibaba.schedulerx.shade.org.h2.expression.Condition;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.schedulerx.shade.org.h2.expression.Parameter;
import com.alibaba.schedulerx.shade.org.h2.expression.ValueExpression;
import com.alibaba.schedulerx.shade.org.h2.index.IndexCondition;
import com.alibaba.schedulerx.shade.org.h2.table.ColumnResolver;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueArray;
import com.alibaba.schedulerx.shade.org.h2.value.ValueBoolean;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.util.AbstractList;

public class ConditionInParameter
extends Condition {
    private final Database database;
    private Expression left;
    private final Parameter parameter;

    public ConditionInParameter(Database database, Expression expression, Parameter parameter) {
        this.database = database;
        this.left = expression;
        this.parameter = parameter;
    }

    @Override
    public Value getValue(Session session) {
        Value value2 = this.left.getValue(session);
        if (value2 == ValueNull.INSTANCE) {
            return value2;
        }
        boolean bl = false;
        boolean bl2 = false;
        Value value3 = this.parameter.getValue(session);
        if (value3 instanceof ValueArray) {
            for (Value value4 : ((ValueArray)value3).getList()) {
                if (value4 == ValueNull.INSTANCE) {
                    bl2 = true;
                    continue;
                }
                bl = Comparison.compareNotNull(this.database, value2, value4 = value4.convertTo(value2.getType()), 0);
                if (!bl) {
                    continue;
                }
                break;
            }
        } else if (value3 == ValueNull.INSTANCE) {
            bl2 = true;
        } else {
            value3 = value3.convertTo(value2.getType());
            bl = Comparison.compareNotNull(this.database, value2, value3, 0);
        }
        if (!bl && bl2) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        if (this.left.isConstant() && this.left == ValueExpression.getNull()) {
            return this.left;
        }
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, new ParameterList(this.parameter)));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
    }

    @Override
    public String getSQL() {
        return '(' + this.left.getSQL() + " = ANY(" + this.parameter.getSQL() + "))";
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.parameter.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    private static final class ParameterList
    extends AbstractList<Expression> {
        private final Parameter parameter;

        ParameterList(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Expression get(int n) {
            Value value2 = this.parameter.getParamValue();
            if (value2 instanceof ValueArray) {
                return ValueExpression.get(((ValueArray)value2).getList()[n]);
            }
            if (n != 0) {
                throw new IndexOutOfBoundsException();
            }
            return ValueExpression.get(value2);
        }

        @Override
        public int size() {
            if (!this.parameter.isValueSet()) {
                return 0;
            }
            Value value2 = this.parameter.getParamValue();
            if (value2 instanceof ValueArray) {
                return ((ValueArray)value2).getList().length;
            }
            return 1;
        }
    }
}

