/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.table;

import com.alibaba.schedulerx.shade.org.h2.command.Prepared;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.index.Index;
import com.alibaba.schedulerx.shade.org.h2.index.IndexType;
import com.alibaba.schedulerx.shade.org.h2.index.LinkedIndex;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.result.RowList;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.IndexColumn;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableLinkConnection;
import com.alibaba.schedulerx.shade.org.h2.table.TableType;
import com.alibaba.schedulerx.shade.org.h2.util.MathUtils;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.value.DataType;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class TableLink
extends Table {
    private static final int MAX_RETRY = 2;
    private static final long ROW_COUNT_APPROXIMATION = 100000L;
    private final String originalSchema;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalTable;
    private String qualifiedTableName;
    private TableLinkConnection conn;
    private HashMap<String, PreparedStatement> preparedMap = new HashMap();
    private final ArrayList<Index> indexes = New.arrayList();
    private final boolean emitUpdates;
    private LinkedIndex linkedIndex;
    private DbException connectException;
    private boolean storesLowerCase;
    private boolean storesMixedCase;
    private boolean storesMixedCaseQuoted;
    private boolean supportsMixedCaseIdentifiers;
    private boolean globalTemporary;
    private boolean readOnly;

    public TableLink(Schema schema, int n, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2) {
        super(schema, n, string2, false, true);
        this.driver = string3;
        this.url = string4;
        this.user = string5;
        this.password = string6;
        this.originalSchema = string7;
        this.originalTable = string8;
        this.emitUpdates = bl;
        try {
            this.connect();
        }
        catch (DbException dbException) {
            if (!bl2) {
                throw dbException;
            }
            Column[] columnArray = new Column[]{};
            this.setColumns(columnArray);
            this.linkedIndex = new LinkedIndex(this, n, IndexColumn.wrap(columnArray), IndexType.createNonUnique(false));
            this.indexes.add(this.linkedIndex);
        }
    }

    private void connect() {
        this.connectException = null;
        int n = 0;
        while (true) {
            try {
                TableLinkConnection tableLinkConnection = this.conn = this.database.getLinkConnection(this.driver, this.url, this.user, this.password);
                synchronized (tableLinkConnection) {
                    try {
                        this.readMetaData();
                        return;
                    }
                    catch (Exception exception) {
                        this.conn.close(true);
                        this.conn = null;
                        throw DbException.convert(exception);
                    }
                }
            }
            catch (DbException dbException) {
                if (n >= 2) {
                    this.connectException = dbException;
                    throw dbException;
                }
                ++n;
                continue;
            }
            break;
        }
    }

    private void readMetaData() throws SQLException {
        Object object;
        Column column;
        int n;
        int n2;
        int n3;
        long l;
        Object object2;
        Object object3;
        Column[] columnArray;
        DatabaseMetaData databaseMetaData = this.conn.getConnection().getMetaData();
        this.storesLowerCase = databaseMetaData.storesLowerCaseIdentifiers();
        this.storesMixedCase = databaseMetaData.storesMixedCaseIdentifiers();
        this.storesMixedCaseQuoted = databaseMetaData.storesMixedCaseQuotedIdentifiers();
        this.supportsMixedCaseIdentifiers = databaseMetaData.supportsMixedCaseIdentifiers();
        ResultSet resultSet = databaseMetaData.getTables(null, this.originalSchema, this.originalTable, null);
        if (resultSet.next() && resultSet.next()) {
            throw DbException.get(90080, this.originalTable);
        }
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, this.originalSchema, this.originalTable, null);
        int n4 = 0;
        ArrayList<Column> arrayList = New.arrayList();
        HashMap<Object, Column> hashMap = new HashMap<Object, Column>();
        String string2 = null;
        String string3 = null;
        while (resultSet.next()) {
            columnArray = resultSet.getString("TABLE_CAT");
            if (string2 == null) {
                string2 = columnArray;
            }
            object3 = resultSet.getString("TABLE_SCHEM");
            if (string3 == null) {
                string3 = object3;
            }
            if (!Objects.equals(string2, columnArray) || !Objects.equals(string3, object3)) {
                hashMap.clear();
                arrayList.clear();
                break;
            }
            object2 = resultSet.getString("COLUMN_NAME");
            object2 = this.convertColumnName((String)object2);
            int n5 = resultSet.getInt("DATA_TYPE");
            String string4 = resultSet.getString("TYPE_NAME");
            l = resultSet.getInt("COLUMN_SIZE");
            l = TableLink.convertPrecision(n5, l);
            n3 = resultSet.getInt("DECIMAL_DIGITS");
            n3 = TableLink.convertScale(n5, n3);
            n2 = MathUtils.convertLongToInt(l);
            n = DataType.convertSQLTypeToValueType(n5, string4);
            column = new Column((String)object2, n, l, n3, n2);
            column.setTable(this, n4++);
            arrayList.add(column);
            hashMap.put(object2, column);
        }
        resultSet.close();
        this.qualifiedTableName = this.originalTable.indexOf(46) < 0 && !StringUtils.isNullOrEmpty(string3) ? string3 + "." + this.originalTable : this.originalTable;
        try {
            columnArray = this.conn.getConnection().createStatement();
            object3 = null;
            try {
                resultSet = columnArray.executeQuery("SELECT * FROM " + this.qualifiedTableName + " T WHERE 1=0");
                if (arrayList.isEmpty()) {
                    object2 = resultSet.getMetaData();
                    n4 = 0;
                    while (n4 < object2.getColumnCount()) {
                        String string5 = object2.getColumnName(n4 + 1);
                        string5 = this.convertColumnName(string5);
                        int n6 = object2.getColumnType(n4 + 1);
                        l = object2.getPrecision(n4 + 1);
                        l = TableLink.convertPrecision(n6, l);
                        n3 = object2.getScale(n4 + 1);
                        n3 = TableLink.convertScale(n6, n3);
                        n2 = object2.getColumnDisplaySize(n4 + 1);
                        n = DataType.getValueTypeFromResultSet((ResultSetMetaData)object2, n4 + 1);
                        column = new Column(string5, n, l, n3, n2);
                        column.setTable(this, n4++);
                        arrayList.add(column);
                        hashMap.put(string5, column);
                    }
                }
                resultSet.close();
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (columnArray != null) {
                    if (object3 != null) {
                        try {
                            columnArray.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        columnArray.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw DbException.get(42102, exception, this.originalTable + "(" + exception.toString() + ")");
        }
        columnArray = arrayList.toArray(new Column[0]);
        this.setColumns(columnArray);
        int n7 = this.getId();
        this.linkedIndex = new LinkedIndex(this, n7, IndexColumn.wrap(columnArray), IndexType.createNonUnique(false));
        this.indexes.add(this.linkedIndex);
        try {
            resultSet = databaseMetaData.getPrimaryKeys(null, this.originalSchema, this.originalTable);
        }
        catch (Exception exception) {
            resultSet = null;
        }
        object2 = "";
        if (resultSet != null && resultSet.next()) {
            ArrayList<Column> arrayList2 = New.arrayList();
            do {
                int n8 = resultSet.getInt("KEY_SEQ");
                if (object2 == null) {
                    object2 = resultSet.getString("PK_NAME");
                }
                while (arrayList2.size() < n8) {
                    arrayList2.add(null);
                }
                String string6 = resultSet.getString("COLUMN_NAME");
                string6 = this.convertColumnName(string6);
                object = (Column)hashMap.get(string6);
                if (n8 == 0) {
                    arrayList2.add((Column)object);
                    continue;
                }
                arrayList2.set(n8 - 1, (Column)object);
            } while (resultSet.next());
            this.addIndex(arrayList2, IndexType.createPrimaryKey(false, false));
            resultSet.close();
        }
        try {
            resultSet = databaseMetaData.getIndexInfo(null, this.originalSchema, this.originalTable, false, true);
        }
        catch (Exception exception) {
            resultSet = null;
        }
        Object object4 = null;
        ArrayList<Column> arrayList3 = New.arrayList();
        IndexType indexType = null;
        if (resultSet != null) {
            while (resultSet.next()) {
                if (resultSet.getShort("TYPE") == 0 || ((String)object2).equals(object = resultSet.getString("INDEX_NAME"))) continue;
                if (object4 != null && !((String)object4).equals(object)) {
                    this.addIndex(arrayList3, indexType);
                    object4 = null;
                }
                if (object4 == null) {
                    object4 = object;
                    arrayList3.clear();
                }
                n3 = !resultSet.getBoolean("NON_UNIQUE") ? 1 : 0;
                indexType = n3 != 0 ? IndexType.createUnique(false, false) : IndexType.createNonUnique(false);
                String string7 = resultSet.getString("COLUMN_NAME");
                string7 = this.convertColumnName(string7);
                Column column2 = (Column)hashMap.get(string7);
                arrayList3.add(column2);
            }
            resultSet.close();
        }
        if (object4 != null) {
            this.addIndex(arrayList3, indexType);
        }
    }

    private static long convertPrecision(int n, long l) {
        switch (n) {
            case 2: 
            case 3: {
                if (l != 0L) break;
                l = 65535L;
                break;
            }
            case 91: {
                l = Math.max(10L, l);
                break;
            }
            case 93: {
                l = Math.max(29L, l);
                break;
            }
            case 92: {
                l = Math.max(18L, l);
            }
        }
        return l;
    }

    private static int convertScale(int n, int n2) {
        switch (n) {
            case 2: 
            case 3: {
                if (n2 >= 0) break;
                n2 = Short.MAX_VALUE;
            }
        }
        return n2;
    }

    private String convertColumnName(String string2) {
        if ((this.storesMixedCase || this.storesLowerCase) && string2.equals(StringUtils.toLowerEnglish(string2))) {
            string2 = StringUtils.toUpperEnglish(string2);
        } else if (this.storesMixedCase && !this.supportsMixedCaseIdentifiers) {
            string2 = StringUtils.toUpperEnglish(string2);
        } else if (this.storesMixedCase && this.storesMixedCaseQuoted) {
            string2 = StringUtils.toUpperEnglish(string2);
        }
        return string2;
    }

    private void addIndex(List<Column> list, IndexType indexType) {
        int n = list.indexOf(null);
        if (n == 0) {
            this.trace.info("Omitting linked index - no recognized columns.");
            return;
        }
        if (n > 0) {
            this.trace.info("Unrecognized columns in linked index. Registering the index against the leading {0} recognized columns of {1} total columns.", n, list.size());
            list = list.subList(0, n);
        }
        Column[] columnArray = list.toArray(new Column[0]);
        LinkedIndex linkedIndex = new LinkedIndex(this, 0, IndexColumn.wrap(columnArray), indexType);
        this.indexes.add(linkedIndex);
    }

    @Override
    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE ");
        if (this.isTemporary()) {
            if (this.globalTemporary) {
                stringBuilder.append("GLOBAL ");
            } else {
                stringBuilder.append("LOCAL ");
            }
            stringBuilder.append("TEMPORARY ");
        }
        stringBuilder.append("LINKED TABLE ").append(this.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append('(').append(StringUtils.quoteStringSQL(this.driver)).append(", ").append(StringUtils.quoteStringSQL(this.url)).append(", ").append(StringUtils.quoteStringSQL(this.user)).append(", ").append(StringUtils.quoteStringSQL(this.password)).append(", ").append(StringUtils.quoteStringSQL(this.originalTable)).append(')');
        if (this.emitUpdates) {
            stringBuilder.append(" EMIT UPDATES");
        }
        if (this.readOnly) {
            stringBuilder.append(" READONLY");
        }
        stringBuilder.append(" /*").append("--hide--").append("*/");
        return stringBuilder.toString();
    }

    @Override
    public Index addIndex(Session session, String string2, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string3) {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.linkedIndex;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
    }

    @Override
    public void removeRow(Session session, Row row) {
        this.checkReadOnly();
        this.getScanIndex(session).remove(session, row);
    }

    @Override
    public void addRow(Session session, Row row) {
        this.checkReadOnly();
        this.getScanIndex(session).add(session, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Session session) {
        if (this.conn != null) {
            try {
                this.conn.close(false);
            }
            finally {
                this.conn = null;
            }
        }
    }

    @Override
    public synchronized long getRowCount(Session session) {
        String string2 = "SELECT COUNT(*) FROM " + this.qualifiedTableName + " as foo";
        try {
            PreparedStatement preparedStatement = this.execute(string2, null, false);
            ResultSet resultSet = preparedStatement.getResultSet();
            resultSet.next();
            long l = resultSet.getLong(1);
            resultSet.close();
            this.reusePreparedStatement(preparedStatement, string2);
            return l;
        }
        catch (Exception exception) {
            throw TableLink.wrapException(string2, exception);
        }
    }

    public static DbException wrapException(String string2, Exception exception) {
        SQLException sQLException = DbException.toSQLException(exception);
        return DbException.get(90111, sQLException, string2, sQLException.toString());
    }

    public String getQualifiedTable() {
        return this.qualifiedTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement execute(String string2, ArrayList<Value> arrayList, boolean bl) {
        if (this.conn == null) {
            throw this.connectException;
        }
        int n = 0;
        while (true) {
            try {
                TableLinkConnection tableLinkConnection = this.conn;
                synchronized (tableLinkConnection) {
                    int n2;
                    PreparedStatement preparedStatement = this.preparedMap.remove(string2);
                    if (preparedStatement == null) {
                        preparedStatement = this.conn.getConnection().prepareStatement(string2);
                    }
                    if (this.trace.isDebugEnabled()) {
                        StatementBuilder statementBuilder = new StatementBuilder();
                        statementBuilder.append(this.getName()).append(":\n").append(string2);
                        if (arrayList != null && !arrayList.isEmpty()) {
                            statementBuilder.append(" {");
                            n2 = 1;
                            for (Value value2 : arrayList) {
                                statementBuilder.appendExceptFirst(", ");
                                statementBuilder.append(n2++).append(": ").append(value2.getSQL());
                            }
                            statementBuilder.append('}');
                        }
                        statementBuilder.append(';');
                        this.trace.debug(statementBuilder.toString());
                    }
                    if (arrayList != null) {
                        n2 = arrayList.size();
                        for (int i = 0; i < n2; ++i) {
                            Value value3 = arrayList.get(i);
                            value3.set(preparedStatement, i + 1);
                        }
                    }
                    preparedStatement.execute();
                    if (bl) {
                        this.reusePreparedStatement(preparedStatement, string2);
                        return null;
                    }
                    return preparedStatement;
                }
            }
            catch (SQLException sQLException) {
                if (n >= 2) {
                    throw DbException.convert(sQLException);
                }
                this.conn.close(true);
                this.connect();
                ++n;
                continue;
            }
            break;
        }
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public TableType getTableType() {
        return TableType.TABLE_LINK;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        super.removeChildrenAndResources(session);
        this.close(session);
        this.database.removeMeta(session, this.getId());
        this.driver = null;
        this.originalTable = null;
        this.password = null;
        this.user = null;
        this.url = null;
        this.preparedMap = null;
        this.invalidate();
    }

    public boolean isOracle() {
        return this.url.startsWith("jdbc:oracle:");
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public Index getUniqueIndex() {
        for (Index index2 : this.indexes) {
            if (!index2.getIndexType().isUnique()) continue;
            return index2;
        }
        return null;
    }

    @Override
    public void updateRows(Prepared prepared, Session session, RowList rowList) {
        boolean bl;
        this.checkReadOnly();
        if (this.emitUpdates) {
            rowList.reset();
            while (rowList.hasNext()) {
                prepared.checkCanceled();
                Row row = rowList.next();
                Row row2 = rowList.next();
                this.linkedIndex.update(row, row2);
                session.log(this, (short)1, row);
                session.log(this, (short)0, row2);
            }
            bl = false;
        } else {
            bl = true;
        }
        if (bl) {
            super.updateRows(prepared, session, rowList);
        }
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public long getRowCountApproximation() {
        return 100000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reusePreparedStatement(PreparedStatement preparedStatement, String string2) {
        TableLinkConnection tableLinkConnection = this.conn;
        synchronized (tableLinkConnection) {
            this.preparedMap.put(string2, preparedStatement);
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public void validateConvertUpdateSequence(Session session, Row row) {
        for (int i = 0; i < this.columns.length; ++i) {
            Column column;
            Value value2;
            Value value3 = row.getValue(i);
            if (value3 == null || (value2 = (column = this.columns[i]).validateConvertUpdateSequence(session, value3)) == value3) continue;
            row.setValue(i, value2);
        }
    }

    @Override
    public Value getDefaultValue(Session session, Column column) {
        return null;
    }
}

