/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.tools;

import com.alibaba.schedulerx.shade.org.h2.command.dml.BackupCommand;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.store.FileLister;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileUtils;
import com.alibaba.schedulerx.shade.org.h2.util.IOUtils;
import com.alibaba.schedulerx.shade.org.h2.util.Tool;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Backup
extends Tool {
    public static void main(String ... stringArray) throws SQLException {
        new Backup().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string2 = "backup.zip";
        String string3 = ".";
        String string4 = null;
        boolean bl = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string5 = stringArray[i];
            if (string5.equals("-dir")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string5.equals("-db")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string5.equals("-quiet")) {
                bl = true;
                continue;
            }
            if (string5.equals("-file")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string5.equals("-help") || string5.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string5);
        }
        try {
            this.process(string2, string3, string4, bl);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    public static void execute(String string2, String string3, String string4, boolean bl) throws SQLException {
        try {
            new Backup().process(string2, string3, string4, bl);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String string2, String string3, String string4, boolean bl) throws SQLException {
        boolean bl2 = string4 != null && string4.length() == 0;
        List<String> list = bl2 ? FileUtils.newDirectoryStream(string3) : FileLister.getDatabaseFiles(string3, string4, true);
        if (list.isEmpty()) {
            if (!bl) {
                this.printNoDatabaseFilesFound(string3, string4);
            }
            return;
        }
        if (!bl) {
            FileLister.tryUnlockDatabase(list, "backup");
        }
        string2 = FileUtils.toRealPath(string2);
        FileUtils.delete(string2);
        OutputStream outputStream = null;
        try {
            outputStream = FileUtils.newOutputStream(string2, false);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
                String string5 = "";
                for (String string6 : list) {
                    if (!bl2 && !string6.endsWith(".h2.db") && !string6.endsWith(".mv.db")) continue;
                    string5 = FileUtils.getParent(string6);
                    break;
                }
                for (String string6 : list) {
                    String string7 = FileUtils.toRealPath(string6);
                    if (!string7.startsWith(string5)) {
                        DbException.throwInternalError(string7 + " does not start with " + string5);
                    }
                    if (string7.endsWith(string2) || FileUtils.isDirectory(string6)) continue;
                    string7 = string7.substring(string5.length());
                    string7 = BackupCommand.correctFileName(string7);
                    ZipEntry zipEntry = new ZipEntry(string7);
                    zipOutputStream.putNextEntry(zipEntry);
                    InputStream inputStream = null;
                    try {
                        inputStream = FileUtils.newInputStream(string6);
                        IOUtils.copyAndCloseInput(inputStream, zipOutputStream);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    finally {
                        IOUtils.closeSilently(inputStream);
                    }
                    zipOutputStream.closeEntry();
                    if (bl) continue;
                    this.out.println("Processed: " + string6);
                }
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string2);
        }
        finally {
            IOUtils.closeSilently(outputStream);
        }
    }
}

