/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.tools;

import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileUtils;
import com.alibaba.schedulerx.shade.org.h2.tools.SimpleResultSet;
import com.alibaba.schedulerx.shade.org.h2.tools.SimpleRowSource;
import com.alibaba.schedulerx.shade.org.h2.util.IOUtils;
import com.alibaba.schedulerx.shade.org.h2.util.JdbcUtils;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class Csv
implements SimpleRowSource {
    private String[] columnNames;
    private String characterSet = SysProperties.FILE_ENCODING;
    private char escapeCharacter = (char)34;
    private char fieldDelimiter = (char)34;
    private char fieldSeparatorRead = (char)44;
    private String fieldSeparatorWrite = ",";
    private boolean caseSensitiveColumnNames;
    private boolean preserveWhitespace;
    private boolean writeColumnHeader = true;
    private char lineComment;
    private String lineSeparator = SysProperties.LINE_SEPARATOR;
    private String nullString = "";
    private String fileName;
    private Reader input;
    private char[] inputBuffer;
    private int inputBufferPos;
    private int inputBufferStart = -1;
    private int inputBufferEnd;
    private Writer output;
    private boolean endOfLine;
    private boolean endOfFile;

    private int writeResultSet(ResultSet resultSet) throws SQLException {
        try {
            int n;
            int n2 = 0;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n3];
            int[] nArray = new int[n3];
            for (n = 0; n < n3; ++n) {
                stringArray[n] = resultSetMetaData.getColumnLabel(n + 1);
                nArray[n] = resultSetMetaData.getColumnType(n + 1);
            }
            if (this.writeColumnHeader) {
                this.writeRow(stringArray);
            }
            while (resultSet.next()) {
                for (n = 0; n < n3; ++n) {
                    Object object;
                    switch (nArray[n]) {
                        case 91: {
                            object = resultSet.getDate(n + 1);
                            break;
                        }
                        case 92: {
                            object = resultSet.getTime(n + 1);
                            break;
                        }
                        case 93: {
                            object = resultSet.getTimestamp(n + 1);
                            break;
                        }
                        default: {
                            object = resultSet.getString(n + 1);
                        }
                    }
                    stringArray[n] = object == null ? null : object.toString();
                }
                this.writeRow(stringArray);
                ++n2;
            }
            this.output.close();
            n = n2;
            return n;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
        finally {
            this.close();
            JdbcUtils.closeSilently(resultSet);
        }
    }

    public int write(Writer writer, ResultSet resultSet) throws SQLException {
        this.output = writer;
        return this.writeResultSet(resultSet);
    }

    public int write(String string2, ResultSet resultSet, String string3) throws SQLException {
        this.init(string2, string3);
        try {
            this.initWrite();
            return this.writeResultSet(resultSet);
        }
        catch (IOException iOException) {
            throw Csv.convertException("IOException writing " + string2, iOException);
        }
    }

    public int write(Connection connection, String string2, String string3, String string4) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string3);
        int n = this.write(string2, resultSet, string4);
        statement.close();
        return n;
    }

    public ResultSet read(String string2, String[] stringArray, String string3) throws SQLException {
        this.init(string2, string3);
        try {
            return this.readResultSet(stringArray);
        }
        catch (IOException iOException) {
            throw Csv.convertException("IOException reading " + string2, iOException);
        }
    }

    public ResultSet read(Reader reader, String[] stringArray) throws IOException {
        this.init(null, null);
        this.input = reader;
        return this.readResultSet(stringArray);
    }

    private ResultSet readResultSet(String[] stringArray) throws IOException {
        this.columnNames = stringArray;
        this.initRead();
        SimpleResultSet simpleResultSet = new SimpleResultSet(this);
        this.makeColumnNamesUnique();
        for (String string2 : this.columnNames) {
            simpleResultSet.addColumn(string2, 12, Integer.MAX_VALUE, 0);
        }
        return simpleResultSet;
    }

    private void makeColumnNamesUnique() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = this.columnNames[i];
            if (string2 == null || string2.length() == 0) {
                stringBuilder.append('C').append(i + 1);
            } else {
                stringBuilder.append(string2);
            }
            for (int j = 0; j < i; ++j) {
                String string3 = this.columnNames[j];
                if (!stringBuilder.toString().equals(string3)) continue;
                stringBuilder.append('1');
                j = -1;
            }
            this.columnNames[i] = stringBuilder.toString();
        }
    }

    private void init(String string2, String string3) {
        this.fileName = string2;
        if (string3 != null) {
            this.characterSet = string3;
        }
    }

    private void initWrite() throws IOException {
        if (this.output == null) {
            try {
                OutputStream outputStream = FileUtils.newOutputStream(this.fileName, false);
                outputStream = new BufferedOutputStream(outputStream, 4096);
                this.output = new BufferedWriter(new OutputStreamWriter(outputStream, this.characterSet));
            }
            catch (Exception exception) {
                this.close();
                throw DbException.convertToIOException(exception);
            }
        }
    }

    private void writeRow(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (i > 0 && this.fieldSeparatorWrite != null) {
                this.output.write(this.fieldSeparatorWrite);
            }
            if ((string2 = stringArray[i]) != null) {
                if (this.escapeCharacter != '\u0000') {
                    if (this.fieldDelimiter != '\u0000') {
                        this.output.write(this.fieldDelimiter);
                    }
                    this.output.write(this.escape(string2));
                    if (this.fieldDelimiter == '\u0000') continue;
                    this.output.write(this.fieldDelimiter);
                    continue;
                }
                this.output.write(string2);
                continue;
            }
            if (this.nullString == null || this.nullString.length() <= 0) continue;
            this.output.write(this.nullString);
        }
        this.output.write(this.lineSeparator);
    }

    private String escape(String string2) {
        if (string2.indexOf(this.fieldDelimiter) < 0 && (this.escapeCharacter == this.fieldDelimiter || string2.indexOf(this.escapeCharacter) < 0)) {
            return string2;
        }
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == this.fieldDelimiter || c == this.escapeCharacter) {
                stringBuilder.append(this.escapeCharacter);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private void initRead() throws IOException {
        if (this.input == null) {
            try {
                InputStream inputStream = FileUtils.newInputStream(this.fileName);
                inputStream = new BufferedInputStream(inputStream, 4096);
                this.input = new InputStreamReader(inputStream, this.characterSet);
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
        }
        if (!this.input.markSupported()) {
            this.input = new BufferedReader(this.input);
        }
        this.input.mark(1);
        int n = this.input.read();
        if (n != 65279) {
            this.input.reset();
        }
        this.inputBuffer = new char[8192];
        if (this.columnNames == null) {
            this.readHeader();
        }
    }

    private void readHeader() throws IOException {
        ArrayList<String> arrayList = New.arrayList();
        while (true) {
            String string2;
            if ((string2 = this.readValue()) == null) {
                if (this.endOfLine) {
                    if (!this.endOfFile && arrayList.isEmpty()) continue;
                    break;
                }
                string2 = "COLUMN" + arrayList.size();
                arrayList.add(string2);
                continue;
            }
            if (string2.length() == 0) {
                string2 = "COLUMN" + arrayList.size();
            } else if (!this.caseSensitiveColumnNames && Csv.isSimpleColumnName(string2)) {
                string2 = StringUtils.toUpperEnglish(string2);
            }
            arrayList.add(string2);
            if (this.endOfLine) break;
        }
        this.columnNames = arrayList.toArray(new String[0]);
    }

    private static boolean isSimpleColumnName(String string2) {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (!(i == 0 ? c != '_' && !Character.isLetter(c) : c != '_' && !Character.isLetterOrDigit(c))) continue;
            return false;
        }
        return string2.length() != 0;
    }

    private void pushBack() {
        --this.inputBufferPos;
    }

    private int readChar() throws IOException {
        if (this.inputBufferPos >= this.inputBufferEnd) {
            return this.readBuffer();
        }
        return this.inputBuffer[this.inputBufferPos++];
    }

    private int readBuffer() throws IOException {
        int n;
        if (this.endOfFile) {
            return -1;
        }
        if (this.inputBufferStart >= 0) {
            n = this.inputBufferPos - this.inputBufferStart;
            if (n > 0) {
                char[] cArray = this.inputBuffer;
                if (n + 4096 > cArray.length) {
                    this.inputBuffer = new char[cArray.length * 2];
                }
                System.arraycopy(cArray, this.inputBufferStart, this.inputBuffer, 0, n);
            }
            this.inputBufferStart = 0;
        } else {
            n = 0;
        }
        this.inputBufferPos = n;
        int n2 = this.input.read(this.inputBuffer, n, 4096);
        if (n2 == -1) {
            this.inputBufferEnd = -1024;
            this.endOfFile = true;
            ++this.inputBufferPos;
            return -1;
        }
        this.inputBufferEnd = n + n2;
        return this.inputBuffer[this.inputBufferPos++];
    }

    private String readValue() throws IOException {
        int n;
        this.endOfLine = false;
        this.inputBufferStart = this.inputBufferPos;
        do {
            if ((n = this.readChar()) == this.fieldDelimiter) {
                int n2;
                boolean bl;
                block16: {
                    bl = false;
                    this.inputBufferStart = this.inputBufferPos;
                    while (true) {
                        if ((n = this.readChar()) == this.fieldDelimiter) {
                            n = this.readChar();
                            if (n != this.fieldDelimiter) {
                                n2 = 2;
                                break block16;
                            }
                            bl = true;
                            continue;
                        }
                        if (n == this.escapeCharacter) {
                            n = this.readChar();
                            if (n < 0) {
                                n2 = 1;
                                break block16;
                            }
                            bl = true;
                            continue;
                        }
                        if (n < 0) break;
                    }
                    n2 = 1;
                }
                String string2 = new String(this.inputBuffer, this.inputBufferStart, this.inputBufferPos - this.inputBufferStart - n2);
                if (bl) {
                    string2 = this.unEscape(string2);
                }
                this.inputBufferStart = -1;
                while (n != this.fieldSeparatorRead) {
                    if (n == 10 || n < 0 || n == 13) {
                        this.endOfLine = true;
                        break;
                    }
                    if (n != 32 && n != 9) {
                        this.pushBack();
                        break;
                    }
                    n = this.readChar();
                }
                return string2;
            }
            if (n == 10 || n < 0 || n == 13) {
                this.endOfLine = true;
                return null;
            }
            if (n != this.fieldSeparatorRead) continue;
            return null;
        } while (n <= 32);
        if (this.lineComment != '\u0000' && n == this.lineComment) {
            this.inputBufferStart = -1;
            while ((n = this.readChar()) != 10 && n >= 0 && n != 13) {
            }
            this.endOfLine = true;
            return null;
        }
        while ((n = this.readChar()) != this.fieldSeparatorRead) {
            if (n != 10 && n >= 0 && n != 13) continue;
            this.endOfLine = true;
            break;
        }
        String string3 = new String(this.inputBuffer, this.inputBufferStart, this.inputBufferPos - this.inputBufferStart - 1);
        if (!this.preserveWhitespace) {
            string3 = string3.trim();
        }
        this.inputBufferStart = -1;
        return this.readNull(string3);
    }

    private String readNull(String string2) {
        return string2.equals(this.nullString) ? null : string2;
    }

    private String unEscape(String string2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        int n2 = 0;
        char[] cArray = null;
        while ((n = string2.indexOf(this.escapeCharacter, n2)) >= 0 || (n = string2.indexOf(this.fieldDelimiter, n2)) >= 0) {
            if (cArray == null) {
                cArray = string2.toCharArray();
            }
            stringBuilder.append(cArray, n2, n - n2);
            if (n == string2.length() - 1) {
                n2 = string2.length();
                break;
            }
            stringBuilder.append(cArray[n + 1]);
            n2 = n + 2;
        }
        stringBuilder.append(string2, n2, string2.length());
        return stringBuilder.toString();
    }

    @Override
    public Object[] readRow() throws SQLException {
        if (this.input == null) {
            return null;
        }
        Object[] objectArray = new String[this.columnNames.length];
        try {
            int n = 0;
            while (true) {
                String string2;
                if ((string2 = this.readValue()) == null && this.endOfLine) {
                    if (n == 0) {
                        if (!this.endOfFile) continue;
                        return null;
                    }
                    break;
                }
                if (n < objectArray.length) {
                    objectArray[n++] = string2;
                }
                if (this.endOfLine) break;
            }
        }
        catch (IOException iOException) {
            throw Csv.convertException("IOException reading from " + this.fileName, iOException);
        }
        return objectArray;
    }

    private static SQLException convertException(String string2, Exception exception) {
        return DbException.get(90028, exception, string2).getSQLException();
    }

    @Override
    public void close() {
        IOUtils.closeSilently(this.input);
        this.input = null;
        IOUtils.closeSilently(this.output);
        this.output = null;
    }

    @Override
    public void reset() throws SQLException {
        throw new SQLException("Method is not supported", "CSV");
    }

    public void setFieldSeparatorWrite(String string2) {
        this.fieldSeparatorWrite = string2;
    }

    public String getFieldSeparatorWrite() {
        return this.fieldSeparatorWrite;
    }

    public void setCaseSensitiveColumnNames(boolean bl) {
        this.caseSensitiveColumnNames = bl;
    }

    public boolean getCaseSensitiveColumnNames() {
        return this.caseSensitiveColumnNames;
    }

    public void setFieldSeparatorRead(char c) {
        this.fieldSeparatorRead = c;
    }

    public char getFieldSeparatorRead() {
        return this.fieldSeparatorRead;
    }

    public void setLineCommentCharacter(char c) {
        this.lineComment = c;
    }

    public char getLineCommentCharacter() {
        return this.lineComment;
    }

    public void setFieldDelimiter(char c) {
        this.fieldDelimiter = c;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setEscapeCharacter(char c) {
        this.escapeCharacter = c;
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setLineSeparator(String string2) {
        this.lineSeparator = string2;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setNullString(String string2) {
        this.nullString = string2;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setPreserveWhitespace(boolean bl) {
        this.preserveWhitespace = bl;
    }

    public boolean getPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public void setWriteColumnHeader(boolean bl) {
        this.writeColumnHeader = bl;
    }

    public boolean getWriteColumnHeader() {
        return this.writeColumnHeader;
    }

    public String setOptions(String string2) {
        String[] stringArray;
        String string3 = null;
        for (String string4 : stringArray = StringUtils.arraySplit(string2, ' ', false)) {
            char c;
            if (string4.length() == 0) continue;
            int n = string4.indexOf(61);
            String string5 = StringUtils.trim(string4.substring(0, n), true, true, " ");
            String string6 = string4.substring(n + 1);
            char c2 = c = string6.length() == 0 ? (char)'\u0000' : string6.charAt(0);
            if (Csv.isParam(string5, "escape", "esc", "escapeCharacter")) {
                this.setEscapeCharacter(c);
                continue;
            }
            if (Csv.isParam(string5, "fieldDelimiter", "fieldDelim")) {
                this.setFieldDelimiter(c);
                continue;
            }
            if (Csv.isParam(string5, "fieldSeparator", "fieldSep")) {
                this.setFieldSeparatorRead(c);
                this.setFieldSeparatorWrite(string6);
                continue;
            }
            if (Csv.isParam(string5, "lineComment", "lineCommentCharacter")) {
                this.setLineCommentCharacter(c);
                continue;
            }
            if (Csv.isParam(string5, "lineSeparator", "lineSep")) {
                this.setLineSeparator(string6);
                continue;
            }
            if (Csv.isParam(string5, "null", "nullString")) {
                this.setNullString(string6);
                continue;
            }
            if (Csv.isParam(string5, "charset", "characterSet")) {
                string3 = string6;
                continue;
            }
            if (Csv.isParam(string5, "preserveWhitespace")) {
                this.setPreserveWhitespace(Utils.parseBoolean(string6, false, false));
                continue;
            }
            if (Csv.isParam(string5, "writeColumnHeader")) {
                this.setWriteColumnHeader(Utils.parseBoolean(string6, true, false));
                continue;
            }
            if (Csv.isParam(string5, "caseSensitiveColumnNames")) {
                this.setCaseSensitiveColumnNames(Utils.parseBoolean(string6, false, false));
                continue;
            }
            throw DbException.getUnsupportedException(string5);
        }
        return string3;
    }

    private static boolean isParam(String string2, String ... stringArray) {
        for (String string3 : stringArray) {
            if (!string2.equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }
}

