/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.util;

import com.alibaba.schedulerx.shade.org.h2.engine.Mode;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueDate;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTime;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTimestamp;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTimestampTimeZone;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTimeUtils {
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final long NANOS_PER_DAY = 86400000000000L;
    private static final int SHIFT_YEAR = 9;
    private static final int SHIFT_MONTH = 5;
    public static final int EPOCH_DATE_VALUE = 1008673;
    private static final int[] NORMAL_DAYS_PER_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] DAYS_OFFSET = new int[]{0, 31, 61, 92, 122, 153, 184, 214, 245, 275, 306, 337, 366};
    private static final int[] CONVERT_SCALE_TABLE = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10};
    private static final ThreadLocal<GregorianCalendar> CACHED_CALENDAR = new ThreadLocal();
    private static final ThreadLocal<GregorianCalendar> CACHED_CALENDAR_NON_DEFAULT_TIMEZONE = new ThreadLocal();
    private static volatile TimeZone timeZone;
    private static int zoneOffsetMillis;

    private DateTimeUtils() {
    }

    private static TimeZone getTimeZone() {
        TimeZone timeZone = DateTimeUtils.timeZone;
        if (timeZone == null) {
            DateTimeUtils.timeZone = timeZone = TimeZone.getDefault();
        }
        return timeZone;
    }

    public static void resetCalendar() {
        CACHED_CALENDAR.remove();
        timeZone = null;
        zoneOffsetMillis = DateTimeUtils.createGregorianCalendar().get(15);
    }

    public static GregorianCalendar getCalendar() {
        GregorianCalendar gregorianCalendar = CACHED_CALENDAR.get();
        if (gregorianCalendar == null) {
            gregorianCalendar = DateTimeUtils.createGregorianCalendar();
            CACHED_CALENDAR.set(gregorianCalendar);
        }
        gregorianCalendar.clear();
        return gregorianCalendar;
    }

    private static GregorianCalendar getCalendar(TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = CACHED_CALENDAR_NON_DEFAULT_TIMEZONE.get();
        if (gregorianCalendar == null || !gregorianCalendar.getTimeZone().equals(timeZone)) {
            gregorianCalendar = DateTimeUtils.createGregorianCalendar(timeZone);
            CACHED_CALENDAR_NON_DEFAULT_TIMEZONE.set(gregorianCalendar);
        }
        gregorianCalendar.clear();
        return gregorianCalendar;
    }

    public static GregorianCalendar createGregorianCalendar() {
        return new GregorianCalendar();
    }

    public static GregorianCalendar createGregorianCalendar(TimeZone timeZone) {
        return new GregorianCalendar(timeZone);
    }

    public static java.sql.Date convertDate(Value value2, Calendar calendar) {
        if (value2 == ValueNull.INSTANCE) {
            return null;
        }
        ValueDate valueDate = (ValueDate)value2.convertTo(10);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.setLenient(true);
        long l = valueDate.getDateValue();
        long l2 = DateTimeUtils.convertToMillis(calendar2, DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l), 0, 0, 0, 0);
        return new java.sql.Date(l2);
    }

    public static Time convertTime(Value value2, Calendar calendar) {
        if (value2 == ValueNull.INSTANCE) {
            return null;
        }
        ValueTime valueTime = (ValueTime)value2.convertTo(9);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.setLenient(true);
        long l = valueTime.getNanos();
        long l2 = l / 1000000L;
        l -= l2 * 1000000L;
        long l3 = l2 / 1000L;
        l2 -= l3 * 1000L;
        long l4 = l3 / 60L;
        l3 -= l4 * 60L;
        long l5 = l4 / 60L;
        return new Time(DateTimeUtils.convertToMillis(calendar2, 1970, 1, 1, (int)l5, (int)(l4 -= l5 * 60L), (int)l3, (int)l2));
    }

    public static Timestamp convertTimestamp(Value value2, Calendar calendar) {
        if (value2 == ValueNull.INSTANCE) {
            return null;
        }
        ValueTimestamp valueTimestamp = (ValueTimestamp)value2.convertTo(11);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.setLenient(true);
        long l = valueTimestamp.getDateValue();
        long l2 = valueTimestamp.getTimeNanos();
        long l3 = l2 / 1000000L;
        l2 -= l3 * 1000000L;
        long l4 = l3 / 1000L;
        l3 -= l4 * 1000L;
        long l5 = l4 / 60L;
        l4 -= l5 * 60L;
        long l6 = l5 / 60L;
        long l7 = DateTimeUtils.convertToMillis(calendar2, DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l), (int)l6, (int)(l5 -= l6 * 60L), (int)l4, (int)l3);
        Timestamp timestamp = new Timestamp(l7);
        timestamp.setNanos((int)(l2 + l3 * 1000000L));
        return timestamp;
    }

    public static ValueDate convertDate(java.sql.Date date, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeInMillis(date.getTime());
        long l = DateTimeUtils.dateValueFromCalendar(calendar2);
        return ValueDate.fromDateValue(l);
    }

    public static ValueTime convertTime(Time time, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeInMillis(time.getTime());
        long l = DateTimeUtils.nanosFromCalendar(calendar2);
        return ValueTime.fromNanos(l);
    }

    public static ValueTimestamp convertTimestamp(Timestamp timestamp, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeInMillis(timestamp.getTime());
        long l = DateTimeUtils.dateValueFromCalendar(calendar2);
        long l2 = DateTimeUtils.nanosFromCalendar(calendar2);
        return ValueTimestamp.fromDateValueAndNanos(l, l2 += (long)(timestamp.getNanos() % 1000000));
    }

    public static long parseDateValue(String string2, int n, int n2) {
        int n3;
        int n4;
        if (string2.charAt(n) == '+') {
            ++n;
        }
        int n5 = string2.indexOf(45, n + 1);
        int n6 = string2.indexOf(45, n5 + 1);
        if (n5 <= 0 || n6 <= n5) {
            throw new IllegalArgumentException(string2);
        }
        int n7 = Integer.parseInt(string2.substring(n, n5));
        if (!DateTimeUtils.isValidDate(n7, n4 = Integer.parseInt(string2.substring(n5 + 1, n6)), n3 = Integer.parseInt(string2.substring(n6 + 1, n2)))) {
            throw new IllegalArgumentException(n7 + "-" + n4 + "-" + n3);
        }
        return DateTimeUtils.dateValue(n7, n4, n3);
    }

    public static long parseTimeNanos(String string2, int n, int n2, boolean bl) {
        boolean bl2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l = 0L;
        int n6 = string2.indexOf(58, n);
        int n7 = string2.indexOf(58, n6 + 1);
        int n8 = string2.indexOf(46, n7 + 1);
        if (n6 <= 0 || n7 <= n6) {
            n6 = string2.indexOf(46, n);
            n7 = string2.indexOf(46, n6 + 1);
            n8 = string2.indexOf(46, n7 + 1);
            if (n6 <= 0 || n7 <= n6) {
                throw new IllegalArgumentException(string2);
            }
        }
        if ((n3 = Integer.parseInt(string2.substring(n, n6))) < 0 || n3 == 0 && string2.charAt(0) == '-') {
            if (bl) {
                throw new IllegalArgumentException(string2);
            }
            bl2 = true;
            n3 = -n3;
        } else {
            bl2 = false;
        }
        n4 = Integer.parseInt(string2.substring(n6 + 1, n7));
        if (n8 < 0) {
            n5 = Integer.parseInt(string2.substring(n7 + 1, n2));
        } else {
            n5 = Integer.parseInt(string2.substring(n7 + 1, n8));
            String string3 = (string2.substring(n8 + 1, n2) + "000000000").substring(0, 9);
            l = Integer.parseInt(string3);
        }
        if (n3 >= 2000000 || n4 < 0 || n4 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException(string2);
        }
        if (bl && n3 >= 24) {
            throw new IllegalArgumentException(string2);
        }
        return bl2 ? -l : (l += (((long)n3 * 60L + (long)n4) * 60L + (long)n5) * 1000000000L);
    }

    private static int findNthIndexOf(String string2, char c, int n) {
        int n2 = string2.indexOf(c);
        while (--n > 0 && n2 != -1) {
            n2 = string2.indexOf(c, n2 + 1);
        }
        return n2;
    }

    public static Value parseTimestamp(String string2, Mode mode, boolean bl) {
        long l;
        int n;
        int n2 = string2.indexOf(32);
        if (n2 < 0 && (n2 = string2.indexOf(84)) < 0 && mode != null && mode.allowDB2TimestampFormat) {
            n2 = DateTimeUtils.findNthIndexOf(string2, '-', 3);
        }
        if (n2 < 0) {
            n2 = string2.length();
            n = -1;
        } else {
            n = n2 + 1;
        }
        long l2 = DateTimeUtils.parseDateValue(string2, 0, n2);
        short s2 = 0;
        if (n < 0) {
            l = 0L;
        } else {
            int n3 = string2.length();
            TimeZone timeZone = null;
            if (string2.endsWith("Z")) {
                timeZone = UTC;
                --n3;
            } else {
                int n4 = string2.indexOf(43, n2 + 1);
                if (n4 < 0) {
                    n4 = string2.indexOf(45, n2 + 1);
                }
                if (n4 >= 0) {
                    String string3;
                    int n5 = string2.indexOf(91, n4 + 1);
                    if (n5 < 0) {
                        n5 = string2.length();
                    }
                    if (!(timeZone = TimeZone.getTimeZone(string3 = "GMT" + string2.substring(n4, n5))).getID().startsWith(string3)) {
                        throw new IllegalArgumentException(string3 + " (" + timeZone.getID() + "?)");
                    }
                    if (string2.charAt(n4 - 1) == ' ') {
                        --n4;
                    }
                    n3 = n4;
                } else {
                    n4 = string2.indexOf(32, n2 + 1);
                    if (n4 > 0) {
                        String string4 = string2.substring(n4 + 1);
                        timeZone = TimeZone.getTimeZone(string4);
                        if (!timeZone.getID().startsWith(string4)) {
                            throw new IllegalArgumentException(string4);
                        }
                        n3 = n4;
                    }
                }
            }
            l = DateTimeUtils.parseTimeNanos(string2, n2 + 1, n3, true);
            if (timeZone != null) {
                if (bl) {
                    if (timeZone != UTC) {
                        long l3 = DateTimeUtils.convertDateTimeValueToMillis(timeZone, l2, l / 1000000L);
                        s2 = (short)(timeZone.getOffset(l3) / 1000 / 60);
                    }
                } else {
                    long l4 = DateTimeUtils.convertDateTimeValueToMillis(timeZone, l2, l / 1000000L);
                    l2 = DateTimeUtils.dateValueFromDate(l4);
                    l = l % 1000000L + DateTimeUtils.nanosFromDate(l4);
                }
            }
        }
        if (bl) {
            return ValueTimestampTimeZone.fromDateValueAndNanos(l2, l, s2);
        }
        return ValueTimestamp.fromDateValueAndNanos(l2, l);
    }

    public static int getTimeZoneOffsetMillis(TimeZone timeZone, long l, long l2) {
        long l3 = l2 / 1000000L;
        long l4 = DateTimeUtils.convertDateTimeValueToMillis(timeZone, l, l3);
        long l5 = DateTimeUtils.absoluteDayFromDateValue(l) * 86400000L + l3;
        return (int)(l5 - l4);
    }

    public static long getMillis(long l, long l2, short s2) {
        return DateTimeUtils.absoluteDayFromDateValue(l) * 86400000L + l2 / 1000000L - (long)(s2 * 60000);
    }

    public static long getMillis(TimeZone timeZone, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GregorianCalendar gregorianCalendar = timeZone == null ? DateTimeUtils.getCalendar() : DateTimeUtils.getCalendar(timeZone);
        gregorianCalendar.setLenient(false);
        try {
            return DateTimeUtils.convertToMillis(gregorianCalendar, n, n2, n3, n4, n5, n6, n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = illegalArgumentException.toString();
            if (string2.indexOf("HOUR_OF_DAY") > 0) {
                if (n4 < 0 || n4 > 23) {
                    throw illegalArgumentException;
                }
            } else if (string2.indexOf("DAY_OF_MONTH") > 0) {
                int n8 = n2 == 2 ? (gregorianCalendar.isLeapYear(n) ? 29 : 28) : NORMAL_DAYS_PER_MONTH[n2];
                if (n3 < 1 || n3 > n8) {
                    throw illegalArgumentException;
                }
                n4 += 6;
            }
            gregorianCalendar.setLenient(true);
            return DateTimeUtils.convertToMillis(gregorianCalendar, n, n2, n3, n4, n5, n6, n7);
        }
    }

    private static long convertToMillis(Calendar calendar, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n <= 0) {
            calendar.set(0, 0);
            calendar.set(1, 1 - n);
        } else {
            calendar.set(0, 1);
            calendar.set(1, n);
        }
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, n7);
        return calendar.getTimeInMillis();
    }

    public static long[] dateAndTimeFromValue(Value value2) {
        long l = 1008673L;
        long l2 = 0L;
        if (value2 instanceof ValueTimestamp) {
            ValueTimestamp valueTimestamp = (ValueTimestamp)value2;
            l = valueTimestamp.getDateValue();
            l2 = valueTimestamp.getTimeNanos();
        } else if (value2 instanceof ValueDate) {
            l = ((ValueDate)value2).getDateValue();
        } else if (value2 instanceof ValueTime) {
            l2 = ((ValueTime)value2).getNanos();
        } else if (value2 instanceof ValueTimestampTimeZone) {
            ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value2;
            l = valueTimestampTimeZone.getDateValue();
            l2 = valueTimestampTimeZone.getTimeNanos();
        } else {
            ValueTimestamp valueTimestamp = (ValueTimestamp)value2.convertTo(11);
            l = valueTimestamp.getDateValue();
            l2 = valueTimestamp.getTimeNanos();
        }
        return new long[]{l, l2};
    }

    public static Value dateTimeToValue(Value value2, long l, long l2, boolean bl) {
        if (!(value2 instanceof ValueTimestamp)) {
            if (!bl) {
                if (value2 instanceof ValueDate) {
                    return ValueDate.fromDateValue(l);
                }
                if (value2 instanceof ValueTime) {
                    return ValueTime.fromNanos(l2);
                }
            }
            if (value2 instanceof ValueTimestampTimeZone) {
                return ValueTimestampTimeZone.fromDateValueAndNanos(l, l2, ((ValueTimestampTimeZone)value2).getTimeZoneOffsetMins());
            }
        }
        return ValueTimestamp.fromDateValueAndNanos(l, l2);
    }

    public static long getTimeLocalWithoutDst(Date date) {
        return date.getTime() + (long)zoneOffsetMillis;
    }

    public static long getTimeUTCWithoutDst(long l) {
        return l - (long)zoneOffsetMillis;
    }

    public static int getDayOfWeek(long l, int n) {
        return DateTimeUtils.getDayOfWeekFromAbsolute(DateTimeUtils.absoluteDayFromDateValue(l), n);
    }

    public static int getDayOfWeekFromAbsolute(long l, int n) {
        return l >= 0L ? (int)((l - (long)n + 11L) % 7L) + 1 : (int)((l - (long)n - 2L) % 7L) + 7;
    }

    public static int getDayOfYear(long l) {
        return (int)(DateTimeUtils.absoluteDayFromDateValue(l) - DateTimeUtils.absoluteDayFromYear(DateTimeUtils.yearFromDateValue(l))) + 1;
    }

    public static int getIsoDayOfWeek(long l) {
        return DateTimeUtils.getDayOfWeek(l, 1);
    }

    public static int getIsoWeekOfYear(long l) {
        return DateTimeUtils.getWeekOfYear(l, 1, 4);
    }

    public static int getIsoWeekYear(long l) {
        return DateTimeUtils.getWeekYear(l, 1, 4);
    }

    public static int getSundayDayOfWeek(long l) {
        return DateTimeUtils.getDayOfWeek(l, 0);
    }

    public static int getWeekOfYear(long l, int n, int n2) {
        int n3;
        long l2;
        long l3 = DateTimeUtils.absoluteDayFromDateValue(l);
        if (l3 - (l2 = DateTimeUtils.getWeekOfYearBase(n3 = DateTimeUtils.yearFromDateValue(l), n, n2)) < 0L) {
            l2 = DateTimeUtils.getWeekOfYearBase(n3 - 1, n, n2);
        } else if (DateTimeUtils.monthFromDateValue(l) == 12 && 24 + n2 < DateTimeUtils.dayFromDateValue(l) && l3 >= DateTimeUtils.getWeekOfYearBase(n3 + 1, n, n2)) {
            return 1;
        }
        return (int)((l3 - l2) / 7L) + 1;
    }

    private static long getWeekOfYearBase(int n, int n2, int n3) {
        long l = DateTimeUtils.absoluteDayFromYear(n);
        int n4 = 8 - DateTimeUtils.getDayOfWeekFromAbsolute(l, n2);
        long l2 = l + (long)n4;
        if (n4 >= n3) {
            l2 -= 7L;
        }
        return l2;
    }

    public static int getWeekYear(long l, int n, int n2) {
        int n3;
        long l2;
        long l3 = DateTimeUtils.absoluteDayFromDateValue(l);
        if (l3 - (l2 = DateTimeUtils.getWeekOfYearBase(n3 = DateTimeUtils.yearFromDateValue(l), n, n2)) < 0L) {
            return n3 - 1;
        }
        if (DateTimeUtils.monthFromDateValue(l) == 12 && 24 + n2 < DateTimeUtils.dayFromDateValue(l) && l3 >= DateTimeUtils.getWeekOfYearBase(n3 + 1, n, n2)) {
            return n3 + 1;
        }
        return n3;
    }

    public static int getDaysInMonth(int n, int n2) {
        if (n2 != 2) {
            return NORMAL_DAYS_PER_MONTH[n2];
        }
        return (n & 3) == 0 && (n < 1582 || n % 100 != 0 || n % 400 == 0) ? 29 : 28;
    }

    public static boolean isValidDate(int n, int n2, int n3) {
        if (n2 < 1 || n2 > 12 || n3 < 1) {
            return false;
        }
        if (n == 1582 && n2 == 10) {
            return n3 < 5 || n3 > 14 && n3 <= 31;
        }
        return n3 <= DateTimeUtils.getDaysInMonth(n, n2);
    }

    public static java.sql.Date convertDateValueToDate(long l) {
        long l2 = DateTimeUtils.getMillis(null, DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l), 0, 0, 0, 0);
        return new java.sql.Date(l2);
    }

    public static long convertDateTimeValueToMillis(TimeZone timeZone, long l, long l2) {
        long l3 = l2 / 1000L;
        l2 -= l3 * 1000L;
        int n = (int)(l3 / 60L);
        l3 -= (long)(n * 60);
        int n2 = n / 60;
        return DateTimeUtils.getMillis(timeZone, DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l), n2, n -= n2 * 60, (int)l3, (int)l2);
    }

    public static Timestamp convertDateValueToTimestamp(long l, long l2) {
        Timestamp timestamp = new Timestamp(DateTimeUtils.convertDateTimeValueToMillis(null, l, l2 / 1000000L));
        timestamp.setNanos((int)(l2 % 1000000000L));
        return timestamp;
    }

    public static Timestamp convertTimestampTimeZoneToTimestamp(long l, long l2, short s2) {
        Timestamp timestamp = new Timestamp(DateTimeUtils.getMillis(l, l2, s2));
        timestamp.setNanos((int)(l2 % 1000000000L));
        return timestamp;
    }

    public static Time convertNanoToTime(long l) {
        long l2 = l / 1000000L;
        long l3 = l2 / 1000L;
        l2 -= l3 * 1000L;
        long l4 = l3 / 60L;
        l3 -= l4 * 60L;
        long l5 = l4 / 60L;
        long l6 = DateTimeUtils.getMillis(null, 1970, 1, 1, (int)(l5 % 24L), (int)(l4 -= l5 * 60L), (int)l3, (int)l2);
        return new Time(l6);
    }

    public static int yearFromDateValue(long l) {
        return (int)(l >>> 9);
    }

    public static int monthFromDateValue(long l) {
        return (int)(l >>> 5) & 0xF;
    }

    public static int dayFromDateValue(long l) {
        return (int)(l & 0x1FL);
    }

    public static long dateValue(long l, int n, int n2) {
        return l << 9 | (long)(n << 5) | (long)n2;
    }

    public static long dateValueFromDenormalizedDate(long l, long l2, int n) {
        long l3 = l2 - 1L;
        long l4 = l3 / 12L;
        if (l3 < 0L && l4 * 12L != l3) {
            --l4;
        }
        int n2 = (int)(l + l4);
        int n3 = (int)(l2 - l4 * 12L);
        if (n < 1) {
            n = 1;
        } else {
            int n4 = DateTimeUtils.getDaysInMonth(n2, n3);
            if (n > n4) {
                n = n4;
            }
        }
        return DateTimeUtils.dateValue(n2, n3, n);
    }

    public static long dateValueFromDate(long l) {
        l += (long)DateTimeUtils.getTimeZone().getOffset(l);
        long l2 = l / 86400000L;
        if (l < 0L && l2 * 86400000L != l) {
            --l2;
        }
        return DateTimeUtils.dateValueFromAbsoluteDay(l2);
    }

    private static long dateValueFromCalendar(Calendar calendar) {
        int n = calendar.get(1);
        if (calendar.get(0) == 0) {
            n = 1 - n;
        }
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        return (long)n << 9 | (long)(n2 << 5) | (long)n3;
    }

    public static long nanosFromDate(long l) {
        l += (long)DateTimeUtils.getTimeZone().getOffset(l);
        long l2 = l / 86400000L;
        if (l < 0L && l2 * 86400000L != l) {
            --l2;
        }
        return (l - l2 * 86400000L) * 1000000L;
    }

    private static long nanosFromCalendar(Calendar calendar) {
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        int n4 = calendar.get(14);
        return ((((long)n * 60L + (long)n2) * 60L + (long)n3) * 1000L + (long)n4) * 1000000L;
    }

    public static ValueTimestamp normalizeTimestamp(long l, long l2) {
        if (l2 > 86400000000000L || l2 < 0L) {
            long l3 = l2 > 86400000000000L ? l2 / 86400000000000L : (l2 - 86400000000000L + 1L) / 86400000000000L;
            l2 -= l3 * 86400000000000L;
            l += l3;
        }
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l), l2);
    }

    public static ValueTimestampTimeZone timestampTimeZoneFromLocalDateValueAndNanos(long l, long l2) {
        int n = DateTimeUtils.getTimeZoneOffsetMillis(null, l, l2);
        int n2 = n / 60000;
        int n3 = n % 60000;
        if (n3 != 0) {
            if ((l2 -= (long)n3) < 0L) {
                l2 += 86400000000000L;
                l = DateTimeUtils.decrementDateValue(l);
            } else if (l2 >= 86400000000000L) {
                l2 -= 86400000000000L;
                l = DateTimeUtils.incrementDateValue(l);
            }
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(l, l2, (short)n2);
    }

    public static long absoluteDayFromYear(long l) {
        long l2 = (--l * 1461L >> 2) - 719177L;
        if (l < 1582L) {
            l2 += 13L;
        } else if (l < 1900L || l > 2099L) {
            l2 += l / 400L - l / 100L + 15L;
        }
        return l2;
    }

    public static long absoluteDayFromDateValue(long l) {
        long l2 = DateTimeUtils.yearFromDateValue(l);
        int n = DateTimeUtils.monthFromDateValue(l);
        int n2 = DateTimeUtils.dayFromDateValue(l);
        if (n <= 2) {
            --l2;
            n += 12;
        }
        long l3 = (l2 * 1461L >> 2) + (long)DAYS_OFFSET[n - 3] + (long)n2 - 719484L;
        if (l2 <= 1582L && (l2 < 1582L || n * 100 + n2 < 1015)) {
            l3 += 13L;
        } else if (l2 < 1900L || l2 > 2099L) {
            l3 += l2 / 400L - l2 / 100L + 15L;
        }
        return l3;
    }

    public static long prolepticGregorianAbsoluteDayFromDateValue(long l) {
        long l2 = DateTimeUtils.yearFromDateValue(l);
        int n = DateTimeUtils.monthFromDateValue(l);
        int n2 = DateTimeUtils.dayFromDateValue(l);
        if (n <= 2) {
            --l2;
            n += 12;
        }
        long l3 = (l2 * 1461L >> 2) + (long)DAYS_OFFSET[n - 3] + (long)n2 - 719484L;
        if (l2 < 1900L || l2 > 2099L) {
            l3 += l2 / 400L - l2 / 100L + 15L;
        }
        return l3;
    }

    public static long dateValueFromAbsoluteDay(long l) {
        long l2;
        long l3;
        long l4;
        long l5 = l + 719468L;
        if (l5 > 578040L) {
            l4 = l5 / 146097L;
            l3 = (l5 -= l4 * 146097L) / 36524L;
            l5 -= l3 * 36524L;
            l2 = l4 * 400L + l3 * 100L;
        } else {
            l3 = 0L;
            l5 += 292200000002L;
            l2 = -800000000L;
        }
        l4 = l5 / 1461L;
        long l6 = (l5 -= l4 * 1461L) / 365L;
        if ((l5 -= l6 * 365L) == 0L && (l6 == 4L || l3 == 4L)) {
            --l6;
            l5 += 365L;
        }
        l6 += l2 + l4 * 4L;
        int n = ((int)l5 * 2 + 1) * 5 / 306;
        l5 -= (long)(DAYS_OFFSET[n] - 1);
        if (n >= 10) {
            ++l6;
            n -= 12;
        }
        return DateTimeUtils.dateValue(l6, n + 3, (int)l5);
    }

    public static long incrementDateValue(long l) {
        int n = DateTimeUtils.yearFromDateValue(l);
        if (n == 1582) {
            return DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(l) + 1L);
        }
        int n2 = DateTimeUtils.dayFromDateValue(l);
        if (n2 < 28) {
            return l + 1L;
        }
        int n3 = DateTimeUtils.monthFromDateValue(l);
        if (n2 < DateTimeUtils.getDaysInMonth(n, n3)) {
            return l + 1L;
        }
        if (n3 < 12) {
            ++n3;
        } else {
            n3 = 1;
            ++n;
        }
        return DateTimeUtils.dateValue(n, n3, 1);
    }

    public static long decrementDateValue(long l) {
        int n = DateTimeUtils.yearFromDateValue(l);
        if (n == 1582) {
            return DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(l) - 1L);
        }
        if (DateTimeUtils.dayFromDateValue(l) > 1) {
            return l - 1L;
        }
        int n2 = DateTimeUtils.monthFromDateValue(l);
        if (n2 > 1) {
            --n2;
        } else {
            n2 = 12;
            --n;
        }
        return DateTimeUtils.dateValue(n, n2, DateTimeUtils.getDaysInMonth(n, n2));
    }

    public static void appendDate(StringBuilder stringBuilder, long l) {
        int n = DateTimeUtils.yearFromDateValue(l);
        int n2 = DateTimeUtils.monthFromDateValue(l);
        int n3 = DateTimeUtils.dayFromDateValue(l);
        if (n > 0 && n < 10000) {
            StringUtils.appendZeroPadded(stringBuilder, 4, n);
        } else {
            stringBuilder.append(n);
        }
        stringBuilder.append('-');
        StringUtils.appendZeroPadded(stringBuilder, 2, n2);
        stringBuilder.append('-');
        StringUtils.appendZeroPadded(stringBuilder, 2, n3);
    }

    public static void appendTime(StringBuilder stringBuilder, long l) {
        if (l < 0L) {
            stringBuilder.append('-');
            l = -l;
        }
        long l2 = -l / -1000000L;
        l -= l2 * 1000000L;
        long l3 = l2 / 1000L;
        l2 -= l3 * 1000L;
        long l4 = l3 / 60L;
        l3 -= l4 * 60L;
        long l5 = l4 / 60L;
        StringUtils.appendZeroPadded(stringBuilder, 2, l5);
        stringBuilder.append(':');
        StringUtils.appendZeroPadded(stringBuilder, 2, l4 -= l5 * 60L);
        stringBuilder.append(':');
        StringUtils.appendZeroPadded(stringBuilder, 2, l3);
        if (l2 > 0L || l > 0L) {
            stringBuilder.append('.');
            int n = stringBuilder.length();
            StringUtils.appendZeroPadded(stringBuilder, 3, l2);
            if (l > 0L) {
                StringUtils.appendZeroPadded(stringBuilder, 6, l);
            }
            for (int i = stringBuilder.length() - 1; i > n && stringBuilder.charAt(i) == '0'; --i) {
                stringBuilder.deleteCharAt(i);
            }
        }
    }

    public static void appendTimeZone(StringBuilder stringBuilder, short s2) {
        if (s2 < 0) {
            stringBuilder.append('-');
            s2 = -s2;
        } else {
            stringBuilder.append('+');
        }
        int n = s2 / 60;
        short s3 = s2 = (short)(s2 - n * 60);
        StringUtils.appendZeroPadded(stringBuilder, 2, n);
        if (s3 != 0) {
            stringBuilder.append(':');
            StringUtils.appendZeroPadded(stringBuilder, 2, s3);
        }
    }

    public static String timestampTimeZoneToString(long l, long l2, short s2) {
        StringBuilder stringBuilder = new StringBuilder(35);
        DateTimeUtils.appendDate(stringBuilder, l);
        stringBuilder.append(' ');
        DateTimeUtils.appendTime(stringBuilder, l2);
        DateTimeUtils.appendTimeZone(stringBuilder, s2);
        return stringBuilder.toString();
    }

    public static String timeZoneNameFromOffsetMins(int n) {
        if (n == 0) {
            return "UTC";
        }
        StringBuilder stringBuilder = new StringBuilder(9);
        stringBuilder.append("GMT");
        if (n < 0) {
            stringBuilder.append('-');
            n = -n;
        } else {
            stringBuilder.append('+');
        }
        StringUtils.appendZeroPadded(stringBuilder, 2, n / 60);
        stringBuilder.append(':');
        StringUtils.appendZeroPadded(stringBuilder, 2, n % 60);
        return stringBuilder.toString();
    }

    public static long convertScale(long l, int n) {
        if (n >= 9) {
            return l;
        }
        int n2 = CONVERT_SCALE_TABLE[n];
        long l2 = l % (long)n2;
        if (l2 >= (long)(n2 >>> 1)) {
            l += (long)n2;
        }
        return l - l2;
    }

    static {
        zoneOffsetMillis = DateTimeUtils.createGregorianCalendar().get(15);
    }
}

