/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.util;

import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileUtils;
import com.alibaba.schedulerx.shade.org.h2.util.IOUtils;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.HashMap;

public class TempFileDeleter {
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final HashMap<PhantomReference<?>, String> refMap = new HashMap();

    private TempFileDeleter() {
    }

    public static TempFileDeleter getInstance() {
        return new TempFileDeleter();
    }

    public synchronized Reference<?> addFile(String string2, Object object) {
        IOUtils.trace("TempFileDeleter.addFile", string2, object);
        PhantomReference<Object> phantomReference = new PhantomReference<Object>(object, this.queue);
        this.refMap.put(phantomReference, string2);
        this.deleteUnused();
        return phantomReference;
    }

    public synchronized void deleteFile(Reference<?> reference, String string2) {
        String string3;
        if (reference != null && (string3 = this.refMap.remove(reference)) != null) {
            if (SysProperties.CHECK && string2 != null && !string3.equals(string2)) {
                DbException.throwInternalError("f2:" + string3 + " f:" + string2);
            }
            string2 = string3;
        }
        if (string2 != null && FileUtils.exists(string2)) {
            try {
                IOUtils.trace("TempFileDeleter.deleteFile", string2, null);
                FileUtils.tryDelete(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void deleteAll() {
        for (String string2 : new ArrayList<String>(this.refMap.values())) {
            this.deleteFile(null, string2);
        }
        this.deleteUnused();
    }

    public void deleteUnused() {
        Reference<Object> reference;
        while (this.queue != null && (reference = this.queue.poll()) != null) {
            this.deleteFile(reference, null);
        }
    }

    public void stopAutoDelete(Reference<?> reference, String string2) {
        IOUtils.trace("TempFileDeleter.stopAutoDelete", string2, reference);
        if (reference != null) {
            String string3 = this.refMap.remove(reference);
            if (SysProperties.CHECK && (string3 == null || !string3.equals(string2))) {
                DbException.throwInternalError("f2:" + string3 + " " + (string3 == null ? "" : string3) + " f:" + string2);
            }
        }
        this.deleteUnused();
    }
}

