/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.FileRegion;
import com.alibaba.schedulerx.shade.org.jboss.netty.logging.InternalLogger;
import com.alibaba.schedulerx.shade.org.jboss.netty.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class DefaultFileRegion
implements FileRegion {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultFileRegion.class);
    private final FileChannel file;
    private final long position;
    private final long count;
    private final boolean releaseAfterTransfer;

    public DefaultFileRegion(FileChannel file, long position, long count2) {
        this(file, position, count2, false);
    }

    public DefaultFileRegion(FileChannel file, long position, long count2, boolean releaseAfterTransfer) {
        this.file = file;
        this.position = position;
        this.count = count2;
        this.releaseAfterTransfer = releaseAfterTransfer;
    }

    public long getPosition() {
        return this.position;
    }

    public long getCount() {
        return this.count;
    }

    public boolean releaseAfterTransfer() {
        return this.releaseAfterTransfer;
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long count2 = this.count - position;
        if (count2 < 0L || position < 0L) {
            throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ')');
        }
        if (count2 == 0L) {
            return 0L;
        }
        return this.file.transferTo(this.position + position, count2, target);
    }

    public void releaseExternalResources() {
        block2: {
            try {
                this.file.close();
            }
            catch (IOException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to close a file.", e);
            }
        }
    }
}

