/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.MessageEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.internal.StringUtil;
import java.net.SocketAddress;

public class DownstreamMessageEvent
implements MessageEvent {
    private final Channel channel;
    private final ChannelFuture future;
    private final Object message;
    private final SocketAddress remoteAddress;

    public DownstreamMessageEvent(Channel channel, ChannelFuture future2, Object message, SocketAddress remoteAddress) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (future2 == null) {
            throw new NullPointerException("future");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.channel = channel;
        this.future = future2;
        this.message = message;
        this.remoteAddress = remoteAddress != null ? remoteAddress : channel.getRemoteAddress();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture getFuture() {
        return this.future;
    }

    public Object getMessage() {
        return this.message;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String toString() {
        if (this.getRemoteAddress() == this.getChannel().getRemoteAddress()) {
            return this.getChannel().toString() + " WRITE: " + StringUtil.stripControlCharacters(this.getMessage());
        }
        return this.getChannel().toString() + " WRITE: " + StringUtil.stripControlCharacters(this.getMessage()) + " to " + this.getRemoteAddress();
    }
}

