/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFutureListener;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelState;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelStateEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channels;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.MessageEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioDatagramWorker;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.WorkerPool;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioDatagramPipelineSink
extends AbstractNioChannelSink {
    private final WorkerPool<NioDatagramWorker> workerPool;

    NioDatagramPipelineSink(WorkerPool<NioDatagramWorker> workerPool) {
        this.workerPool = workerPool;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        NioDatagramChannel channel = (NioDatagramChannel)e.getChannel();
        ChannelFuture future2 = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value2 = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value2)) break;
                    channel.worker.close(channel, future2);
                    break;
                }
                case BOUND: {
                    if (value2 != null) {
                        NioDatagramPipelineSink.bind(channel, future2, (InetSocketAddress)value2);
                        break;
                    }
                    channel.worker.close(channel, future2);
                    break;
                }
                case CONNECTED: {
                    if (value2 != null) {
                        NioDatagramPipelineSink.connect(channel, future2, (InetSocketAddress)value2);
                        break;
                    }
                    NioDatagramWorker.disconnect(channel, future2);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future2, (Integer)value2);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }

    private static void close(NioDatagramChannel channel, ChannelFuture future2) {
        try {
            channel.getDatagramChannel().socket().close();
            if (channel.setClosed()) {
                future2.setSuccess();
                if (channel.isBound()) {
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future2.setSuccess();
            }
        }
        catch (Throwable t) {
            future2.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void bind(NioDatagramChannel channel, ChannelFuture future2, InetSocketAddress address) {
        boolean bound2 = false;
        boolean started = false;
        try {
            try {
                channel.getDatagramChannel().socket().bind(address);
                bound2 = true;
                future2.setSuccess();
                Channels.fireChannelBound(channel, (SocketAddress)address);
                channel.worker.register(channel, null);
                return;
            }
            catch (Throwable t) {
                future2.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var7_6 = null;
                if (started) return;
                if (!bound2) return;
                NioDatagramPipelineSink.close(channel, future2);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (started || !bound2) throw throwable;
            NioDatagramPipelineSink.close(channel, future2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connect(NioDatagramChannel channel, ChannelFuture future2, InetSocketAddress remoteAddress) {
        boolean bound2 = channel.isBound();
        boolean connected2 = false;
        boolean workerStarted = false;
        future2.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        channel.remoteAddress = null;
        try {
            try {
                channel.getDatagramChannel().connect(remoteAddress);
                connected2 = true;
                future2.setSuccess();
                if (!bound2) {
                    Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                }
                Channels.fireChannelConnected(channel, (SocketAddress)channel.getRemoteAddress());
                if (!bound2) {
                    channel.worker.register(channel, future2);
                }
                workerStarted = true;
            }
            catch (Throwable t) {
                future2.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var8_7 = null;
                if (connected2 && !workerStarted) {
                    channel.worker.close(channel, future2);
                }
            }
            Object var8_6 = null;
            if (connected2 && !workerStarted) {
                channel.worker.close(channel, future2);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (connected2 && !workerStarted) {
                channel.worker.close(channel, future2);
            }
            throw throwable;
        }
    }

    NioDatagramWorker nextWorker() {
        return this.workerPool.nextWorker();
    }
}

