/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.SocketChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.OioClientSocketChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.OioClientSocketPipelineSink;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.ThreadNameDeterminer;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class OioClientSocketChannelFactory
implements ClientSocketChannelFactory {
    private final Executor workerExecutor;
    final OioClientSocketPipelineSink sink;
    private boolean shutdownExecutor;

    public OioClientSocketChannelFactory() {
        this(Executors.newCachedThreadPool());
        this.shutdownExecutor = true;
    }

    public OioClientSocketChannelFactory(Executor workerExecutor) {
        this(workerExecutor, null);
    }

    public OioClientSocketChannelFactory(Executor workerExecutor, ThreadNameDeterminer determiner) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new OioClientSocketPipelineSink(workerExecutor, determiner);
    }

    public SocketChannel newChannel(ChannelPipeline pipeline) {
        return new OioClientSocketChannel(this, pipeline, this.sink);
    }

    public void shutdown() {
        if (this.shutdownExecutor) {
            ExecutorUtil.shutdownNow(this.workerExecutor);
        }
    }

    public void releaseExternalResources() {
        ExecutorUtil.shutdownNow(this.workerExecutor);
    }
}

