/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFutureListener;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelState;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelStateEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channels;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.MessageEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.AbstractOioChannelSink;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.AbstractOioWorker;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.OioClientSocketChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.oio.OioWorker;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.ThreadNameDeterminer;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.ThreadRenamingRunnable;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.internal.DeadLockProofWorker;
import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

class OioClientSocketPipelineSink
extends AbstractOioChannelSink {
    private final Executor workerExecutor;
    private final ThreadNameDeterminer determiner;

    OioClientSocketPipelineSink(Executor workerExecutor, ThreadNameDeterminer determiner) {
        this.workerExecutor = workerExecutor;
        this.determiner = determiner;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        OioClientSocketChannel channel = (OioClientSocketChannel)e.getChannel();
        ChannelFuture future2 = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value2 = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value2)) break;
                    AbstractOioWorker.close(channel, future2);
                    break;
                }
                case BOUND: {
                    if (value2 != null) {
                        OioClientSocketPipelineSink.bind(channel, future2, (SocketAddress)value2);
                        break;
                    }
                    AbstractOioWorker.close(channel, future2);
                    break;
                }
                case CONNECTED: {
                    if (value2 != null) {
                        this.connect(channel, future2, (SocketAddress)value2);
                        break;
                    }
                    AbstractOioWorker.close(channel, future2);
                    break;
                }
                case INTEREST_OPS: {
                    AbstractOioWorker.setInterestOps(channel, future2, (Integer)value2);
                }
            }
        } else if (e instanceof MessageEvent) {
            OioWorker.write(channel, future2, ((MessageEvent)e).getMessage());
        }
    }

    private static void bind(OioClientSocketChannel channel, ChannelFuture future2, SocketAddress localAddress) {
        try {
            channel.socket.bind(localAddress);
            future2.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
        }
        catch (Throwable t) {
            future2.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect(OioClientSocketChannel channel, ChannelFuture future2, SocketAddress remoteAddress) {
        boolean bound2 = channel.isBound();
        boolean connected2 = false;
        boolean workerStarted = false;
        future2.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        try {
            try {
                channel.socket.connect(remoteAddress, channel.getConfig().getConnectTimeoutMillis());
                connected2 = true;
                channel.in = new PushbackInputStream(channel.socket.getInputStream(), 1);
                channel.out = channel.socket.getOutputStream();
                future2.setSuccess();
                if (!bound2) {
                    Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                }
                Channels.fireChannelConnected(channel, (SocketAddress)channel.getRemoteAddress());
                DeadLockProofWorker.start(this.workerExecutor, new ThreadRenamingRunnable(new OioWorker(channel), "Old I/O client worker (" + channel + ')', this.determiner));
                workerStarted = true;
            }
            catch (Throwable t22) {
                ConnectException t22;
                if (t22 instanceof ConnectException && t22 instanceof ConnectException) {
                    ConnectException newT = new ConnectException(t22.getMessage() + ": " + remoteAddress);
                    newT.setStackTrace(t22.getStackTrace());
                    t22 = newT;
                }
                future2.setFailure(t22);
                Channels.fireExceptionCaught(channel, (Throwable)t22);
                Object var10_8 = null;
                if (!connected2) return;
                if (workerStarted) return;
                AbstractOioWorker.close(channel, future2);
                return;
            }
            Object var10_7 = null;
            if (!connected2) return;
            if (workerStarted) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (!connected2) throw throwable;
            if (workerStarted) throw throwable;
            AbstractOioWorker.close(channel, future2);
            throw throwable;
        }
        AbstractOioWorker.close(channel, future2);
    }
}

