/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http;

import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.HttpMessage;
import java.util.Iterator;
import java.util.List;

final class HttpCodecUtil {
    static void validateHeaderName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException("name contains non-ascii character: " + name);
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("name contains one of the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + name);
                }
            }
        }
    }

    static void validateHeaderValue(String value2) {
        if (value2 == null) {
            throw new NullPointerException("value");
        }
        int state = 0;
        block19: for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            switch (c) {
                case '\u000b': {
                    throw new IllegalArgumentException("value contains a prohibited character '\\v': " + value2);
                }
                case '\f': {
                    throw new IllegalArgumentException("value contains a prohibited character '\\f': " + value2);
                }
            }
            switch (state) {
                case 0: {
                    switch (c) {
                        case '\r': {
                            state = 1;
                            break;
                        }
                        case '\n': {
                            state = 2;
                        }
                    }
                    continue block19;
                }
                case 1: {
                    switch (c) {
                        case '\n': {
                            state = 2;
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Only '\\n' is allowed after '\\r': " + value2);
                }
                case 2: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            state = 0;
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Only ' ' and '\\t' are allowed after '\\n': " + value2);
                }
            }
        }
        if (state != 0) {
            throw new IllegalArgumentException("value must not end with '\\r' or '\\n':" + value2);
        }
    }

    static boolean isTransferEncodingChunked(HttpMessage m) {
        List<String> chunked = m.headers().getAll("Transfer-Encoding");
        if (chunked.isEmpty()) {
            return false;
        }
        for (String v : chunked) {
            if (!v.equalsIgnoreCase("chunked")) continue;
            return true;
        }
        return false;
    }

    static void removeTransferEncodingChunked(HttpMessage m) {
        List<String> values2 = m.headers().getAll("Transfer-Encoding");
        if (values2.isEmpty()) {
            return;
        }
        Iterator<String> valuesIt = values2.iterator();
        while (valuesIt.hasNext()) {
            String value2 = valuesIt.next();
            if (!value2.equalsIgnoreCase("chunked")) continue;
            valuesIt.remove();
        }
        if (values2.isEmpty()) {
            m.headers().remove("Transfer-Encoding");
        } else {
            m.headers().set("Transfer-Encoding", values2);
        }
    }

    static boolean isContentLengthSet(HttpMessage m) {
        List<String> contentLength = m.headers().getAll("Content-Length");
        return !contentLength.isEmpty();
    }

    private HttpCodecUtil() {
    }
}

