/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.websocketx;

import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFutureListener;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.HttpRequest;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.HttpVersion;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.websocketx.WebSocket07FrameEncoder;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.alibaba.schedulerx.shade.org.jboss.netty.logging.InternalLogger;
import com.alibaba.schedulerx.shade.org.jboss.netty.logging.InternalLoggerFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.CharsetUtil;

public class WebSocketServerHandshaker07
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker07.class);
    public static final String WEBSOCKET_07_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final boolean allowExtensions;

    public WebSocketServerHandshaker07(String webSocketURL, String subprotocols, boolean allowExtensions, long maxFramePayloadLength) {
        super(WebSocketVersion.V07, webSocketURL, subprotocols, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 7 server handshake", channel.getId()));
        }
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        String key = req.headers().get("Sec-WebSocket-Key");
        if (key == null) {
            throw new WebSocketHandshakeException("not a WebSocket request: missing key");
        }
        String acceptSeed = key + WEBSOCKET_07_ACCEPT_GUID;
        ChannelBuffer sha1 = WebSocketUtil.sha1(ChannelBuffers.copiedBuffer(acceptSeed, CharsetUtil.US_ASCII));
        String accept2 = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("WS Version 7 Server Handshake key: %s. Response: %s.", key, accept2));
        }
        res.setStatus(HttpResponseStatus.SWITCHING_PROTOCOLS);
        res.headers().add("Upgrade", "WebSocket".toLowerCase());
        res.headers().add("Connection", "Upgrade");
        res.headers().add("Sec-WebSocket-Accept", accept2);
        String subprotocols = req.headers().get("Sec-WebSocket-Protocol");
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
            }
            res.headers().add("Sec-WebSocket-Protocol", selectedSubprotocol);
            this.setSelectedSubprotocol(selectedSubprotocol);
        }
        return this.writeHandshakeResponse(channel, res, new WebSocket07FrameEncoder(false), new WebSocket07FrameDecoder(true, this.allowExtensions, this.getMaxFramePayloadLength()));
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        ChannelFuture future2 = channel.write(frame);
        future2.addListener(ChannelFutureListener.CLOSE);
        return future2;
    }
}

