/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.socks;

import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelHandlerContext;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.socks.SocksCommonUtils;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.socks.SocksInitResponse;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.socks.SocksMessage;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.socks.SocksResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocksInitResponseDecoder
extends ReplayingDecoder<State> {
    private SocksMessage.ProtocolVersion version;
    private SocksMessage.AuthScheme authScheme;
    private SocksResponse msg = SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE;

    public SocksInitResponseDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        switch (state) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.ProtocolVersion.fromByte(buffer.readByte());
                if (this.version != SocksMessage.ProtocolVersion.SOCKS5) break;
                this.checkpoint(State.READ_PREFFERED_AUTH_TYPE);
            }
            case READ_PREFFERED_AUTH_TYPE: {
                this.authScheme = SocksMessage.AuthScheme.fromByte(buffer.readByte());
                this.msg = new SocksInitResponse(this.authScheme);
            }
        }
        ctx.getPipeline().remove(this);
        return this.msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_PREFFERED_AUTH_TYPE;

    }
}

