/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.handler.stream;

import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ChunkedNioFile
implements ChunkedInput {
    private final FileChannel in;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    public ChunkedNioFile(File in2) throws IOException {
        this(new FileInputStream(in2).getChannel());
    }

    public ChunkedNioFile(File in2, int chunkSize) throws IOException {
        this(new FileInputStream(in2).getChannel(), chunkSize);
    }

    public ChunkedNioFile(FileChannel in2) throws IOException {
        this(in2, 8192);
    }

    public ChunkedNioFile(FileChannel in2, int chunkSize) throws IOException {
        this(in2, 0L, in2.size(), chunkSize);
    }

    public ChunkedNioFile(FileChannel in2, long offset, long length, int chunkSize) throws IOException {
        if (in2 == null) {
            throw new NullPointerException("in");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset: " + offset + " (expected: 0 or greater)");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length: " + length + " (expected: 0 or greater)");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize + " (expected: a positive integer)");
        }
        if (offset != 0L) {
            in2.position(offset);
        }
        this.in = in2;
        this.chunkSize = chunkSize;
        this.offset = this.startOffset = offset;
        this.endOffset = offset + length;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public long getCurrentOffset() {
        return this.offset;
    }

    public boolean hasNextChunk() throws Exception {
        return this.offset < this.endOffset && this.in.isOpen();
    }

    public boolean isEndOfInput() throws Exception {
        return !this.hasNextChunk();
    }

    public void close() throws Exception {
        this.in.close();
    }

    public Object nextChunk() throws Exception {
        int localReadBytes;
        long offset = this.offset;
        if (offset >= this.endOffset) {
            return null;
        }
        int chunkSize = (int)Math.min((long)this.chunkSize, this.endOffset - offset);
        byte[] chunkArray = new byte[chunkSize];
        ByteBuffer chunk = ByteBuffer.wrap(chunkArray);
        int readBytes2 = 0;
        while ((localReadBytes = this.in.read(chunk)) >= 0 && (readBytes2 += localReadBytes) != chunkSize) {
        }
        this.offset += (long)readBytes2;
        return ChannelBuffers.wrappedBuffer(chunkArray);
    }
}

