/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.util.internal;

import java.util.ArrayList;
import java.util.Formatter;

public final class StringUtil {
    public static final String NEWLINE;
    private static final String EMPTY_STRING = "";

    private StringUtil() {
    }

    public static String stripControlCharacters(Object value2) {
        if (value2 == null) {
            return null;
        }
        return StringUtil.stripControlCharacters(value2.toString());
    }

    public static String stripControlCharacters(String value2) {
        int i;
        if (value2 == null) {
            return null;
        }
        boolean hasControlChars = false;
        for (int i2 = value2.length() - 1; i2 >= 0; --i2) {
            if (!Character.isISOControl(value2.charAt(i2))) continue;
            hasControlChars = true;
            break;
        }
        if (!hasControlChars) {
            return value2;
        }
        StringBuilder buf = new StringBuilder(value2.length());
        for (i = 0; i < value2.length() && Character.isISOControl(value2.charAt(i)); ++i) {
        }
        boolean suppressingControlChars = false;
        while (i < value2.length()) {
            if (Character.isISOControl(value2.charAt(i))) {
                suppressingControlChars = true;
            } else {
                if (suppressingControlChars) {
                    suppressingControlChars = false;
                    buf.append(' ');
                }
                buf.append(value2.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    public static String[] split(String value2, char delim) {
        int i;
        int end = value2.length();
        ArrayList<String> res = new ArrayList<String>();
        int start2 = 0;
        for (i = 0; i < end; ++i) {
            if (value2.charAt(i) != delim) continue;
            if (start2 == i) {
                res.add(EMPTY_STRING);
            } else {
                res.add(value2.substring(start2, i));
            }
            start2 = i + 1;
        }
        if (start2 == 0) {
            res.add(value2);
        } else if (start2 != end) {
            res.add(value2.substring(start2, end));
        } else {
            for (i = res.size() - 1; i >= 0 && ((String)res.get(i)).length() == 0; --i) {
                res.remove(i);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public static String[] split(String value2, char delim, int maxParts) {
        int i;
        int end = value2.length();
        ArrayList<String> res = new ArrayList<String>();
        int start2 = 0;
        int cpt = 1;
        for (i = 0; i < end && cpt < maxParts; ++i) {
            if (value2.charAt(i) != delim) continue;
            if (start2 == i) {
                res.add(EMPTY_STRING);
            } else {
                res.add(value2.substring(start2, i));
            }
            start2 = i + 1;
            ++cpt;
        }
        if (start2 == 0) {
            res.add(value2);
        } else if (start2 != end) {
            res.add(value2.substring(start2, end));
        } else {
            for (i = res.size() - 1; i >= 0 && ((String)res.get(i)).length() == 0; --i) {
                res.remove(i);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public static String substringAfter(String value2, char delim) {
        int pos = value2.indexOf(delim);
        if (pos >= 0) {
            return value2.substring(pos + 1);
        }
        return null;
    }

    static {
        String newLine;
        try {
            newLine = new Formatter().format("%n", new Object[0]).toString();
        }
        catch (Exception e) {
            newLine = "\n";
        }
        NEWLINE = newLine;
    }
}

