/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.batch;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.batch.BaseReqHandler;
import com.alibaba.schedulerx.worker.batch.ReqQueue;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerStatusReqHandler<T>
extends BaseReqHandler<T> {
    private String taskMasterAkkaPath;
    private boolean enableShareContainerPool = ConfigUtil.getWorkerConfig().getBoolean("share.container.pool", false);
    private static final Logger LOGGER = LogFactory.getLogger(ContainerStatusReqHandler.class);

    @Override
    public void process(long jobInstanceId, List<T> reqs, String workerAddr) {
        this.batchProcessSvc.submit(new BatchStatuesReportRunnable(jobInstanceId, reqs));
    }

    public ContainerStatusReqHandler(long jobInstanceId, int coreBatchThreadNum, int maxBatchThreadNum, int batchSize, ReqQueue<T> queue2, String taskMasterAkkaPath) {
        super(jobInstanceId, coreBatchThreadNum, maxBatchThreadNum, batchSize, queue2, "Schedulerx-Container-Batch-Statuses-Process-Thread-", "Schedulerx-Container-Batch-Statues-Retrieve-Thread-");
        this.taskMasterAkkaPath = taskMasterAkkaPath;
        this.defaultSleepMs = 10L;
    }

    public String getTaskMasterAkkaPath() {
        return this.taskMasterAkkaPath;
    }

    private class BatchStatuesReportRunnable
    implements Runnable {
        private long jobInstanceId;
        private List<Worker.ContainerReportTaskStatusRequest> statues;

        BatchStatuesReportRunnable(long jobInstanceId, List<Worker.ContainerReportTaskStatusRequest> reqs) {
            this.jobInstanceId = jobInstanceId;
            this.statues = reqs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (ContainerStatusReqHandler.this.enableShareContainerPool) {
                    long jobInstanceId;
                    HashMap<Long, ArrayList<Worker.ContainerReportTaskStatusRequest>> taskStatusRequestMap = Maps.newHashMap();
                    for (Worker.ContainerReportTaskStatusRequest containerReportTaskStatusRequest : this.statues) {
                        jobInstanceId = containerReportTaskStatusRequest.getJobInstanceId();
                        if (taskStatusRequestMap.containsKey(jobInstanceId)) {
                            ((List)taskStatusRequestMap.get(jobInstanceId)).add(containerReportTaskStatusRequest);
                            continue;
                        }
                        ArrayList<Worker.ContainerReportTaskStatusRequest> reqsByInstance = Lists.newArrayList(containerReportTaskStatusRequest);
                        taskStatusRequestMap.put(jobInstanceId, reqsByInstance);
                    }
                    for (Map.Entry entry : taskStatusRequestMap.entrySet()) {
                        jobInstanceId = (Long)entry.getKey();
                        String instanceMasterActorPath = null;
                        ArrayList<Worker.TaskStatusInfo> taskStatuses = Lists.newArrayList();
                        for (Worker.ContainerReportTaskStatusRequest req : (List)entry.getValue()) {
                            instanceMasterActorPath = req.getInstanceMasterActorPath();
                            Worker.TaskStatusInfo.Builder builder = Worker.TaskStatusInfo.newBuilder().setTaskId(req.getTaskId()).setStatus(req.getStatus());
                            if (req.hasTaskName()) {
                                builder.setTaskName(req.getTaskName());
                            }
                            if (req.hasResult()) {
                                builder.setResult(req.getResult());
                            }
                            taskStatuses.add(builder.build());
                        }
                        if (instanceMasterActorPath != null) {
                            Worker.ContainerReportTaskStatusRequest taskStatusRequest = (Worker.ContainerReportTaskStatusRequest)((List)entry.getValue()).get(0);
                            Worker.ContainerBatchReportTaskStatuesRequest request2 = Worker.ContainerBatchReportTaskStatuesRequest.newBuilder().setJobId(taskStatusRequest.getJobId()).setJobInstanceId(jobInstanceId).addAllTaskStatues(taskStatuses).setTaskMasterAkkaPath(instanceMasterActorPath).setWorkerAddr(taskStatusRequest.getWorkerAddr()).setWorkerId(taskStatusRequest.getWorkerId()).setSerialNum(taskStatusRequest.getSerialNum()).build();
                            SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(request2, null);
                            LOGGER.info("jobInstanceId={} batch report status={} to task master, size:{}", jobInstanceId, taskStatusRequest.getStatus(), this.statues.size());
                            continue;
                        }
                        LOGGER.error("instanceMasterActorPath is null, jobInstanceId={}", jobInstanceId);
                    }
                } else {
                    ArrayList<Worker.TaskStatusInfo> taskStatuses = Lists.newArrayList();
                    Worker.ContainerReportTaskStatusRequest taskStatusRequest = this.statues.get(0);
                    for (Worker.ContainerReportTaskStatusRequest req : this.statues) {
                        Worker.TaskStatusInfo.Builder builder = Worker.TaskStatusInfo.newBuilder().setTaskId(req.getTaskId()).setStatus(req.getStatus());
                        if (req.hasTaskName()) {
                            builder.setTaskName(req.getTaskName());
                        }
                        if (req.hasResult()) {
                            builder.setResult(req.getResult());
                        }
                        taskStatuses.add(builder.build());
                    }
                    Worker.ContainerBatchReportTaskStatuesRequest request3 = Worker.ContainerBatchReportTaskStatuesRequest.newBuilder().setJobId(taskStatusRequest.getJobId()).setJobInstanceId(taskStatusRequest.getJobInstanceId()).addAllTaskStatues(taskStatuses).setTaskMasterAkkaPath(ContainerStatusReqHandler.this.taskMasterAkkaPath).setWorkerAddr(taskStatusRequest.getWorkerAddr()).setWorkerId(taskStatusRequest.getWorkerId()).setSerialNum(taskStatusRequest.getSerialNum()).build();
                    SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(request3, null);
                    LOGGER.info("jobInstanceId={} batch report status={} to task master, size:{}", this.jobInstanceId, taskStatusRequest.getStatus(), this.statues.size());
                }
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
            finally {
                ContainerStatusReqHandler.this.activeRunnableNum.decrementAndGet();
            }
        }
    }
}

