/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.discovery;

import akka.actor.ActorSystem;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.discovery.ServerDiscovery;
import com.alibaba.schedulerx.worker.discovery.ServerDiscoveryFactory;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.util.ConsoleUtil;
import java.io.IOException;
import java.util.Map;

public enum GroupManager {
    INSTANCE;

    private String namespace;
    private String namespaceSource;
    private Map<String, Long> groupId2AppGroupIdMap = Maps.newConcurrentMap();
    private Map<String, Integer> parentGroupId2CountMap = Maps.newConcurrentMap();
    private static final Logger LOGGER;

    public void init(String namespace, String namespaceSource) {
        this.namespace = namespace;
        this.namespaceSource = namespaceSource;
    }

    public int getCountByParentGroupId(String parentGroupId) {
        if (this.parentGroupId2CountMap.containsKey(parentGroupId)) {
            return this.parentGroupId2CountMap.get(parentGroupId);
        }
        return 0;
    }

    public boolean contains(String groupId) {
        return this.groupId2AppGroupIdMap.containsKey(groupId);
    }

    public void appendGroupId(String groupId, String parentGroupId) throws IOException {
        long appGroupId = ConsoleUtil.getAppGroupId(groupId, this.namespace, this.namespaceSource);
        if (appGroupId <= 0L) {
            throw new IOException("groupId=" + groupId + " is not exist, namespace=" + this.namespace);
        }
        this.groupId2AppGroupIdMap.put(groupId, appGroupId);
        if (this.parentGroupId2CountMap.containsKey(parentGroupId)) {
            int count2 = this.parentGroupId2CountMap.get(parentGroupId);
            this.parentGroupId2CountMap.put(parentGroupId, count2 + 1);
        } else {
            this.parentGroupId2CountMap.put(parentGroupId, 1);
        }
    }

    public Map<String, Long> getGroupId2AppGroupIdMap() {
        return this.groupId2AppGroupIdMap;
    }

    public void startServerDiscovery(String groupId) throws Exception {
        ServerDiscovery discovery = ServerDiscoveryFactory.getDiscovery(groupId);
        discovery.start(this.namespace, this.namespaceSource, groupId);
    }

    public void reset(ActorSystem actorSystem) throws Exception {
        for (String groupId : this.groupId2AppGroupIdMap.keySet()) {
            ServerDiscovery discovery = ServerDiscoveryFactory.getDiscovery(groupId);
            discovery.reset(actorSystem);
        }
    }

    static {
        LOGGER = LogFactory.getLogger(SchedulerxWorker.class);
    }
}

