/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.ha;

import akka.actor.ActorSelection;
import akka.japi.Function;
import akka.persistence.AtLeastOnceDelivery;
import akka.persistence.SnapshotOffer;
import akka.persistence.UntypedPersistentActorWithAtLeastOnceDelivery;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.worker.discovery.ServerDiscoveryFactory;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.util.ActorPathUtil;
import java.util.List;

public class AtLeastOnceDeliveryActor
extends UntypedPersistentActorWithAtLeastOnceDelivery {
    private int id = 0;
    private static final Logger LOGGER = LogFactory.getLogger(AtLeastOnceDeliveryActor.class);

    public AtLeastOnceDeliveryActor(int id) {
        this.id = id;
    }

    @Override
    public String persistenceId() {
        return "persistence-id-" + this.id;
    }

    @Override
    public void onReceiveCommand(Object obj) {
        block23: {
            try {
                if (obj instanceof Worker.WorkerReportJobInstanceStatusRequest) {
                    this.handleReportInstanceStatusEvent((Worker.WorkerReportJobInstanceStatusRequest)obj);
                    break block23;
                }
                if (obj instanceof Worker.WorkerBatchReportTaskStatuesRequest) {
                    this.handleBatchReportTaskStatues((Worker.WorkerBatchReportTaskStatuesRequest)obj);
                    break block23;
                }
                if (obj instanceof Worker.ContainerBatchReportTaskStatuesRequest) {
                    this.handleContainerBatchStatus((Worker.ContainerBatchReportTaskStatuesRequest)obj);
                    break block23;
                }
                if (obj instanceof Worker.MasterDestroyContainerPoolRequest) {
                    this.handleDestroyContainerPool((Worker.MasterDestroyContainerPoolRequest)obj);
                    break block23;
                }
                if (obj instanceof Worker.WorkerReportJobInstanceStatusResponse) {
                    Worker.WorkerReportJobInstanceStatusResponse response = (Worker.WorkerReportJobInstanceStatusResponse)obj;
                    if (response.getSuccess()) {
                        this.confirmDelivery(response.getDeliveryId());
                    } else {
                        LOGGER.error("WorkerReportJobInstanceStatus not success, reason:{}", response.getMessage());
                    }
                    break block23;
                }
                if (obj instanceof Worker.WorkerBatchReportTaskStatuesResponse) {
                    Worker.WorkerBatchReportTaskStatuesResponse response = (Worker.WorkerBatchReportTaskStatuesResponse)obj;
                    if (response.getSuccess()) {
                        this.confirmDelivery(response.getDeliveryId());
                    } else {
                        LOGGER.error("WorkerBatchReportTaskStatues not success, reason:{}", response.getMessage());
                    }
                    break block23;
                }
                if (obj instanceof Worker.ContainerBatchReportTaskStatuesResponse) {
                    Worker.ContainerBatchReportTaskStatuesResponse response = (Worker.ContainerBatchReportTaskStatuesResponse)obj;
                    if (response.getSuccess()) {
                        this.confirmDelivery(response.getDeliveryId());
                    } else {
                        LOGGER.error("ContainerBatchReportTaskStatues not success, reason:{}", response.getMessage());
                    }
                    break block23;
                }
                if (obj instanceof Worker.MasterDestroyContainerPoolResponse) {
                    Worker.MasterDestroyContainerPoolResponse response = (Worker.MasterDestroyContainerPoolResponse)obj;
                    if (response.getSuccess()) {
                        this.confirmDelivery(response.getDeliveryId());
                    } else {
                        LOGGER.error("MasterDestroyContainerPool not success, reason:{}", response.getMessage());
                    }
                    break block23;
                }
                if (obj instanceof AtLeastOnceDelivery.UnconfirmedWarning) {
                    try {
                        List<AtLeastOnceDelivery.UnconfirmedDelivery> list = ((AtLeastOnceDelivery.UnconfirmedWarning)obj).getUnconfirmedDeliveries();
                        for (AtLeastOnceDelivery.UnconfirmedDelivery unconfirmedDelivery : list) {
                            Object unConfirmedMsg = unconfirmedDelivery.getMessage();
                            long deliveryId = (Long)ReflectionUtil.invokeMethod(unConfirmedMsg, "getDeliveryId");
                            this.confirmDelivery(deliveryId);
                            this.unConfirmRetry(unConfirmedMsg);
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                        break block23;
                    }
                }
                if (obj instanceof SnapshotOffer) {
                    AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot snapshot = (AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot)((SnapshotOffer)obj).snapshot();
                    this.setDeliverySnapshot(snapshot);
                }
            }
            catch (Throwable e) {
                LOGGER.error("", e);
            }
        }
    }

    @Override
    public void onReceiveRecover(Object obj) throws Throwable {
    }

    private void handleReportInstanceStatusEvent(final Worker.WorkerReportJobInstanceStatusRequest request2) {
        ActorSelection serverSelection = ServerDiscoveryFactory.getDiscovery(request2.getGroupId()).getInstanceStatusRouter();
        this.deliver(serverSelection, new Function<Long, Object>(){

            @Override
            public Object apply(Long deliveryId) {
                return request2.toBuilder().setDeliveryId(deliveryId).build();
            }
        });
        LOGGER.info("report jobInstance={}, status={} to server={}", request2.getJobInstanceId(), request2.getStatus(), serverSelection);
    }

    private void handleBatchReportTaskStatues(final Worker.WorkerBatchReportTaskStatuesRequest request2) {
        ActorSelection serverSelection = ServerDiscoveryFactory.getDiscovery(request2.getGroupId()).getTaskStatusRouter();
        this.deliver(serverSelection, new Function<Long, Object>(){

            @Override
            public Object apply(Long deliveryId) {
                return request2.toBuilder().setDeliveryId(deliveryId).build();
            }
        });
        LOGGER.debug("batch report task statues jobInstanceId={} to server={}", request2.getJobInstanceId(), serverSelection);
    }

    private void handleContainerBatchStatus(final Worker.ContainerBatchReportTaskStatuesRequest request2) {
        ActorSelection taskMasterSelection = this.getContext().actorSelection(request2.getTaskMasterAkkaPath());
        this.deliver(taskMasterSelection, new Function<Long, Object>(){

            @Override
            public Object apply(Long deliveryId) {
                return request2.toBuilder().setDeliveryId(deliveryId).build();
            }
        });
    }

    private void handleDestroyContainerPool(final Worker.MasterDestroyContainerPoolRequest request2) {
        ActorSelection selection = this.getContext().actorSelection(ActorPathUtil.getContainerRouterPath(request2.getWorkerIdAddr()));
        this.deliver(selection, new Function<Long, Object>(){

            @Override
            public Object apply(Long deliveryId) {
                return request2.toBuilder().setDeliveryId(deliveryId).build();
            }
        });
    }

    private void unConfirmRetry(Object msg) {
        Worker.WorkerReportJobInstanceStatusRequest request2;
        if (msg instanceof Worker.ContainerBatchReportTaskStatuesRequest) {
            Worker.ContainerBatchReportTaskStatuesRequest request3 = (Worker.ContainerBatchReportTaskStatuesRequest)msg;
            if (!request3.hasAlreadyUnConfirmRetry() || !request3.getAlreadyUnConfirmRetry()) {
                request3 = request3.toBuilder().setAlreadyUnConfirmRetry(true).build();
                this.getSelf().tell(request3, null);
                LOGGER.info("jobInstanceId={}, ContainerBatchReportTaskStatuesRequest unconfirm retry", request3.getJobInstanceId());
            }
        } else if (msg instanceof Worker.MasterDestroyContainerPoolRequest) {
            Worker.MasterDestroyContainerPoolRequest request4 = (Worker.MasterDestroyContainerPoolRequest)msg;
            if (!request4.hasAlreadyUnConfirmRetry() || !request4.getAlreadyUnConfirmRetry()) {
                request4 = request4.toBuilder().setAlreadyUnConfirmRetry(true).build();
                this.getSelf().tell(request4, null);
                LOGGER.info("MasterDestroyContainerPoolRequest unconfirm retry, jobInstanceId={}, workerIdAddr={}", request4.getJobInstanceId(), request4.getWorkerIdAddr());
            }
        } else if (msg instanceof Worker.WorkerBatchReportTaskStatuesRequest) {
            Worker.WorkerBatchReportTaskStatuesRequest request5 = (Worker.WorkerBatchReportTaskStatuesRequest)msg;
            if (!request5.hasAlreadyUnConfirmRetry() || !request5.getAlreadyUnConfirmRetry()) {
                request5 = request5.toBuilder().setAlreadyUnConfirmRetry(true).build();
                this.getSelf().tell(request5, null);
                LOGGER.info("jobInstanceId={}, WorkerBatchReportTaskStatuesRequest unconfirm retry", request5.getJobInstanceId());
            }
        } else if (!(!(msg instanceof Worker.WorkerReportJobInstanceStatusRequest) || (request2 = (Worker.WorkerReportJobInstanceStatusRequest)msg).hasAlreadyUnConfirmRetry() && request2.getAlreadyUnConfirmRetry())) {
            request2 = request2.toBuilder().setAlreadyUnConfirmRetry(true).build();
            this.getSelf().tell(request2, null);
            LOGGER.info("jobInstanceId={}, WorkerReportJobInstanceStatusRequest unconfirm retry", request2.getJobInstanceId());
        }
    }
}

