/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.logcollector;

import com.alibaba.schedulerx.common.domain.LogReadResult;
import com.alibaba.schedulerx.common.domain.StreamType;
import java.io.IOException;
import java.util.List;

public abstract class LogCollector {
    public static char END_OF_LOG = (char)4;

    public void collectStdout(String line) {
        this.collect(line, StreamType.STD_OUT, false);
    }

    public void collectStderr(String line) {
        this.collect(line, StreamType.STD_ERR, false);
    }

    public void collectStdout(String line, boolean isEnd) {
        this.collect(line, StreamType.STD_OUT, isEnd);
    }

    public void collectStderr(String line, boolean isEnd) {
        this.collect(line, StreamType.STD_ERR, isEnd);
    }

    public void collect(String key, String line) {
        this.collect(key, line, StreamType.STD_OUT, false);
    }

    public void collect(String key, String line, Throwable t) {
        this.collect(key, line, t, StreamType.STD_ERR, false);
    }

    public void collect(String line, StreamType streamType, boolean isEnd) {
        this.collect(null, line, streamType, isEnd);
    }

    public void collect(String key, String line, StreamType streamType, boolean isEnd) {
        this.collect(key, line, null, streamType, isEnd);
    }

    public abstract void collect(String var1, String var2, Throwable var3, StreamType var4, boolean var5);

    public List<String> readLines(long lineOffset, int lineNumber, StreamType streamType) throws IOException {
        return null;
    }

    public LogReadResult readChars(long offset, int size2, StreamType streamType) throws IOException {
        return null;
    }

    public List<String> tailLines(int lineNumber, StreamType streamType) throws IOException {
        return null;
    }

    public void delete() throws IOException {
    }
}

