/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.logcollector;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.DefaultLogCollector;
import com.alibaba.schedulerx.worker.logcollector.LocalLogCleaner;
import com.alibaba.schedulerx.worker.logcollector.LogCleaner;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;

public class LogCollectorFactory {
    private static LogCollector collector = null;
    private static final Logger LOGGER = LogFactory.getLogger(LogCollectorFactory.class);

    public static LogCleaner newCleaner() {
        return new LocalLogCleaner();
    }

    public static synchronized LogCollector get() {
        if (collector == null) {
            String logCollectorType = ConfigUtil.getWorkerConfig().getString("log.collector.type", "default");
            String className = ConfigUtil.getWorkerConfig().getString("log.collector." + logCollectorType, DefaultLogCollector.class.getName());
            if (!ConfigUtil.getWorkerConfig().getBoolean("sls.log.enable", true)) {
                className = DefaultLogCollector.class.getName();
            }
            try {
                collector = (LogCollector)ReflectionUtil.getInstanceByClassName(className, SchedulerxWorker.CUSTOMER_CLASS_LOADER);
            }
            catch (Throwable e) {
                LOGGER.error("", e);
                throw new RuntimeException(e);
            }
        }
        return collector;
    }
}

