/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor.demo;

import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.MapReduceJobProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import java.util.ArrayList;
import java.util.Map;

public class TestMapReduceJobProcessor
extends MapReduceJobProcessor {
    private static final Logger LOGGER = LogFactory.getLogger("data");

    @Override
    public ProcessResult process(JobContext context) throws Exception {
        String taskName = context.getTaskName();
        int num = Integer.valueOf(context.getJobParameters());
        if (this.isRootTask(context)) {
            LOGGER.info("start root task");
            ArrayList<OrderInfo> orderInfos = new ArrayList<OrderInfo>();
            for (int i = 1; i <= num; ++i) {
                orderInfos.add(new OrderInfo("id_" + i, i));
            }
            return this.map(orderInfos, "OrderInfo");
        }
        if (taskName.equals("OrderInfo")) {
            OrderInfo orderInfo = (OrderInfo)context.getTask();
            LOGGER.info("orderInfo=" + orderInfo);
            return new ProcessResult(true, String.valueOf(orderInfo.getValue()));
        }
        return new ProcessResult(false);
    }

    @Override
    public ProcessResult reduce(JobContext context) throws Exception {
        Map<Long, String> allTaskResults = context.getTaskResults();
        Map<Long, TaskStatus> allTaskStatuses = context.getTaskStatuses();
        int count2 = 0;
        for (Map.Entry<Long, String> entry : allTaskResults.entrySet()) {
            if (entry.getKey() == 0L || !allTaskStatuses.get(entry.getKey()).equals((Object)TaskStatus.SUCCESS)) continue;
            count2 += Integer.valueOf(entry.getValue()).intValue();
        }
        LOGGER.info("reduce: count=" + count2);
        return new ProcessResult(true, String.valueOf(count2));
    }

    static class OrderInfo {
        private String id;
        private int value;

        public OrderInfo(String id, int value2) {
            this.id = id;
            this.value = value2;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value2) {
            this.value = value2;
        }

        public String toString() {
            return "OrderInfo [id=" + this.id + ", value=" + this.value + "]";
        }
    }
}

