/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor.demo;

import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.MapJobProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import com.alibaba.schedulerx.worker.processor.demo.TestTaskObject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TestParallelJobProcessor
extends MapJobProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(TestParallelJobProcessor.class);
    private static final String FIRST_LEVEL_DISPATCH = "FIRST_LEVEL_DISPATCH";

    @Override
    public ProcessResult process(JobContext context) {
        String taskName = context.getTaskName();
        if ("MAP_TASK_ROOT".equals(taskName)) {
            LOGGER.info("[TestParallelJobProcessor] Start root task.");
            LOGGER.info("jobId={}, jobInstanceId={}, jobParameters={}, instanceParameters={}", context.getJobId(), context.getJobInstanceId(), context.getJobParameters(), context.getInstanceParameters());
            List<TestTaskObject> tasks = this.buildFirstLevelDispatchTasks();
            if (CollectionUtils.isEmpty(tasks)) {
                return new ProcessResult(true);
            }
            return this.map(tasks, FIRST_LEVEL_DISPATCH);
        }
        if (FIRST_LEVEL_DISPATCH.equals(taskName)) {
            LOGGER.info("[TestParallelJobProcessor] Start FIRST_LEVEL_DISPATCH task.");
            TestTaskObject taskObject = (TestTaskObject)context.getTask();
            LOGGER.info("TestTaskObject={}", taskObject);
            return new ProcessResult(true);
        }
        return new ProcessResult(false);
    }

    private List<TestTaskObject> buildFirstLevelDispatchTasks() {
        ArrayList<TestTaskObject> tasks = Lists.newArrayList();
        for (int i = 0; i <= 100; ++i) {
            tasks.add(new TestTaskObject(i, "Hello SchedulerX2.0! This is [TestParallelJobProcessor] msg_" + i));
        }
        return tasks;
    }
}

