/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.security;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpResponse;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.JsonNode;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.Unirest;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.exceptions.UnirestException;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.exception.AuthenticateException;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.security.Authenticator;
import java.util.HashMap;
import java.util.List;

public class DefaultAuthenticator
implements Authenticator {
    private static final String AUTHENTICATE_URL = "/worker/v1/appgroup/authenticate";
    private static final Logger LOGGER = LogFactory.getLogger(DefaultAuthenticator.class);

    @Override
    public void authenticate(Configuration conf, String namespace, String namespaceSource, List<String> groupIds) throws AuthenticateException {
        Object[] appKeys;
        JSONResult result2 = JSONResult.geneFailResult();
        String appKeyProperty = System.getProperty("schedulerx.appKey");
        if (StringUtils.isNotBlank(appKeyProperty)) {
            conf.setProperty("appKey", appKeyProperty);
        }
        if ((appKeys = conf.getStringArray("appKey")).length <= 0) {
            throw new AuthenticateException("please set appKey for groupId=" + groupIds);
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(namespace)) {
            parameterMap.put("namespace", namespace);
        }
        if (StringUtils.isNotBlank(namespaceSource)) {
            parameterMap.put("namespaceSource", namespaceSource);
        }
        parameterMap.put("groups", StringUtils.join(groupIds, ","));
        parameterMap.put("accessKey", StringUtils.join(appKeys, ","));
        parameterMap.put("type", "authenticate_default");
        String domain = ConfigUtil.getWorkerConfig().getString("domainName");
        if (StringUtils.isNotBlank(domain)) {
            String url = "http://" + domain + AUTHENTICATE_URL;
            try {
                HttpResponse<JsonNode> jsonResponse = Unirest.post(url).fields(parameterMap).asJson();
                if (jsonResponse != null) {
                    result2 = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
                }
            }
            catch (UnirestException e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groupIds, url, e);
            }
            catch (Exception e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groupIds, url, e);
            }
        }
        if (result2 != null) {
            if (!result2.isSuccess() || !((Boolean)result2.getData()).booleanValue()) {
                throw new AuthenticateException(result2.getMessage());
            }
        } else {
            throw new AuthenticateException("authenticate result is null");
        }
    }
}

