/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.timer;

import com.alibaba.schedulerx.worker.domain.TaskStatistics;
import com.alibaba.schedulerx.worker.master.persistence.H2FilePersistence;
import com.alibaba.schedulerx.worker.master.persistence.H2MemoryPersistence;
import com.alibaba.schedulerx.worker.timer.AbstractTimerTask;

public class JobInstanceCheckTimer
extends AbstractTimerTask {
    @Override
    public String getName() {
        return "JobInstanceCheckTimer";
    }

    @Override
    public long getInitialDelay() {
        return 60L;
    }

    @Override
    public long getPeriod() {
        return 60L;
    }

    @Override
    public void run() {
        try {
            TaskStatistics fileTaskStatistics;
            TaskStatistics memTaskStatistics;
            if (H2MemoryPersistence.getInstance().isInited() && (memTaskStatistics = H2MemoryPersistence.getInstance().getTaskStatistics()) != null) {
                LOGGER.info("h2 mem distinct instance count: {}, total task count: {}", memTaskStatistics.getDistinctInstanceCount(), memTaskStatistics.getTaskCount());
            }
            if (H2FilePersistence.getInstance().isInited() && (fileTaskStatistics = H2FilePersistence.getInstance().getTaskStatistics()) != null) {
                LOGGER.info("h2 file distinct instance count: {}, total task count: {}", fileTaskStatistics.getDistinctInstanceCount(), fileTaskStatistics.getTaskCount());
            }
        }
        catch (Throwable e) {
            LOGGER.error("JobInstanceCheckTimer run error.", e);
        }
    }
}

