/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.domain.JobInstanceData;
import com.alibaba.schedulerx.common.util.HessianUtil;
import com.alibaba.schedulerx.protocol.Common;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.domain.ShardingTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class ContanerUtil {
    public static JobContext convert2JobContext(Worker.MasterStartContainerRequest request2) throws IOException {
        JobContext.JobContextBuilder contextBuilder = JobContext.newBuilder();
        contextBuilder.setJobId(request2.getJobId());
        contextBuilder.setJobInstanceId(request2.getJobInstanceId());
        contextBuilder.setTaskId(request2.getTaskId());
        contextBuilder.setScheduleTime(new DateTime(request2.getScheduleTime()));
        contextBuilder.setDataTime(new DateTime(request2.getDataTime()));
        contextBuilder.setExecuteMode(request2.getExecuteMode());
        contextBuilder.setJobType(request2.getJobType());
        contextBuilder.setContent(request2.getContent());
        contextBuilder.setJobParameters(request2.getParameters());
        contextBuilder.setInstanceParameters(request2.getInstanceParameters());
        contextBuilder.setUser(request2.getUser());
        contextBuilder.setTaskMasterActorPath(request2.getInstanceMasterAkkaPath());
        contextBuilder.setGroupId(request2.getGroupId());
        contextBuilder.setMaxAttempt(request2.getMaxAttempt());
        contextBuilder.setAttempt(request2.getAttempt());
        if (request2.hasTaskName()) {
            contextBuilder.setTaskName(request2.getTaskName());
        }
        if (request2.hasTask()) {
            Object obj = HessianUtil.toObject(request2.getTask().toByteArray());
            contextBuilder.setTask(obj);
            if (obj instanceof ShardingTask) {
                ShardingTask shardingTask = (ShardingTask)obj;
                contextBuilder.setShardingId(shardingTask.getId());
                contextBuilder.setShardingParameter(shardingTask.getParameter());
            }
        } else {
            contextBuilder.setShardingId(request2.getTaskId());
        }
        if (request2.hasTaskMaxAttempt()) {
            contextBuilder.setTaskMaxAttempt(request2.getTaskMaxAttempt());
        }
        if (request2.hasTaskAttemptInterval()) {
            contextBuilder.setTaskAttemptInterval(request2.getTaskAttemptInterval());
        }
        List<Common.UpstreamData> upstreamProtoDatas = request2.getUpstreamDataList();
        ArrayList<JobInstanceData> upstreamDatas = Lists.newArrayList();
        for (Common.UpstreamData upstreamData : upstreamProtoDatas) {
            upstreamDatas.add(new JobInstanceData(upstreamData.getJobName(), upstreamData.getData()));
        }
        contextBuilder.setUpstreamData(upstreamDatas);
        if (request2.hasWfInstanceId()) {
            contextBuilder.setWfInstanceId(request2.getWfInstanceId());
        }
        if (request2.hasSerialNum()) {
            contextBuilder.setSerialNum(request2.getSerialNum());
        }
        if (request2.hasJobName()) {
            contextBuilder.setJobName(request2.getJobName());
        }
        if (request2.hasShardingNum()) {
            contextBuilder.setShardingNum(request2.getShardingNum());
        }
        return contextBuilder.build();
    }
}

