/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.MyClassLoader;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.domain.JavaProcessorProfile;
import com.alibaba.schedulerx.worker.processor.JavaProcessor;
import com.alibaba.schedulerx.worker.processor.JobProcessor;
import com.alibaba.schedulerx.worker.util.FileDownloader;
import com.alibaba.schedulerx.worker.util.SpringContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class JavaProcessorProfileUtil {
    public static JobProcessor getJavaProcessor(String content) throws Exception {
        JobProcessor jobProcessor;
        JavaProcessorProfile profile = JsonUtil.fromJson(content, JavaProcessorProfile.class);
        if (profile.getJarUrl() == null || profile.getJarUrl().isEmpty()) {
            jobProcessor = SpringContext.context != null ? (JobProcessor)SpringContext.getBean(profile.getClassName(), SchedulerxWorker.CUSTOMER_CLASS_LOADER) : (JobProcessor)ReflectionUtil.getInstanceByClassName(profile.getClassName(), SchedulerxWorker.CUSTOMER_CLASS_LOADER);
        } else {
            String jarUrl;
            String jarFilePath = jarUrl = profile.getJarUrl();
            MyClassLoader classLoader = new MyClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
            if (jarUrl.startsWith("file:")) {
                jarFilePath = jarUrl.substring("file:".length());
            } else if (jarUrl.startsWith("http:")) {
                jarFilePath = FileDownloader.httpDownload(jarUrl);
            } else if (jarUrl.startsWith("hdfs:")) {
                // empty if block
            }
            File jarFile = new File(jarFilePath);
            if (!jarFile.exists()) {
                throw new IOException(jarFilePath + "is not existed!");
            }
            classLoader.addJar(jarFile.toURI().toURL());
            if (SpringContext.context != null) {
                jobProcessor = (JobProcessor)SpringContext.getBean(profile.getClassName(), classLoader);
            } else {
                Class<?> clazz = classLoader.loadClass(profile.getClassName());
                jobProcessor = (JavaProcessor)ReflectionUtil.newInstanceWithoutCache(clazz);
            }
        }
        return jobProcessor;
    }
}

