/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.com.google.protobuf;

import com.aliyun.log.thirdparty.com.google.protobuf.ByteString;
import com.aliyun.log.thirdparty.com.google.protobuf.CodedInputStream;
import com.aliyun.log.thirdparty.com.google.protobuf.CodedOutputStream;
import com.aliyun.log.thirdparty.com.google.protobuf.ExtensionRegistryLite;
import com.aliyun.log.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import com.aliyun.log.thirdparty.com.google.protobuf.LazyStringList;
import com.aliyun.log.thirdparty.com.google.protobuf.MessageLite;
import com.aliyun.log.thirdparty.com.google.protobuf.UninitializedMessageException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;

public abstract class AbstractMessageLite
implements MessageLite {
    public ByteString toByteString() {
        try {
            ByteString.CodedBuilder out = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(out.getCodedOutput());
            return out.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a ByteString threw an IOException (should never happen).", e);
        }
    }

    public byte[] toByteArray() {
        try {
            byte[] result2 = new byte[this.getSerializedSize()];
            CodedOutputStream output = CodedOutputStream.newInstance(result2);
            this.writeTo(output);
            output.checkNoSpaceLeft();
            return result2;
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    public void writeTo(OutputStream output) throws IOException {
        int bufferSize = CodedOutputStream.computePreferredBufferSize(this.getSerializedSize());
        CodedOutputStream codedOutput = CodedOutputStream.newInstance(output, bufferSize);
        this.writeTo(codedOutput);
        codedOutput.flush();
    }

    public void writeDelimitedTo(OutputStream output) throws IOException {
        int serialized = this.getSerializedSize();
        int bufferSize = CodedOutputStream.computePreferredBufferSize(CodedOutputStream.computeRawVarint32Size(serialized) + serialized);
        CodedOutputStream codedOutput = CodedOutputStream.newInstance(output, bufferSize);
        codedOutput.writeRawVarint32(serialized);
        this.writeTo(codedOutput);
        codedOutput.flush();
    }

    UninitializedMessageException newUninitializedMessageException() {
        return new UninitializedMessageException(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<BuilderType extends Builder>
    implements MessageLite.Builder {
        public abstract BuilderType clone();

        public BuilderType mergeFrom(CodedInputStream input2) throws IOException {
            return (BuilderType)this.mergeFrom(input2, ExtensionRegistryLite.getEmptyRegistry());
        }

        public abstract BuilderType mergeFrom(CodedInputStream var1, ExtensionRegistryLite var2) throws IOException;

        public BuilderType mergeFrom(ByteString data) throws InvalidProtocolBufferException {
            try {
                CodedInputStream input2 = data.newCodedInput();
                this.mergeFrom(input2);
                input2.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException e) {
                throw e;
            }
            catch (IOException e) {
                throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", e);
            }
        }

        public BuilderType mergeFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            try {
                CodedInputStream input2 = data.newCodedInput();
                this.mergeFrom(input2, extensionRegistry);
                input2.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException e) {
                throw e;
            }
            catch (IOException e) {
                throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", e);
            }
        }

        public BuilderType mergeFrom(byte[] data) throws InvalidProtocolBufferException {
            return (BuilderType)this.mergeFrom(data, 0, data.length);
        }

        public BuilderType mergeFrom(byte[] data, int off, int len2) throws InvalidProtocolBufferException {
            try {
                CodedInputStream input2 = CodedInputStream.newInstance(data, off, len2);
                this.mergeFrom(input2);
                input2.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException e) {
                throw e;
            }
            catch (IOException e) {
                throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", e);
            }
        }

        public BuilderType mergeFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (BuilderType)this.mergeFrom(data, 0, data.length, extensionRegistry);
        }

        public BuilderType mergeFrom(byte[] data, int off, int len2, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            try {
                CodedInputStream input2 = CodedInputStream.newInstance(data, off, len2);
                this.mergeFrom(input2, extensionRegistry);
                input2.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException e) {
                throw e;
            }
            catch (IOException e) {
                throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", e);
            }
        }

        public BuilderType mergeFrom(InputStream input2) throws IOException {
            CodedInputStream codedInput = CodedInputStream.newInstance(input2);
            this.mergeFrom(codedInput);
            codedInput.checkLastTagWas(0);
            return (BuilderType)this;
        }

        public BuilderType mergeFrom(InputStream input2, ExtensionRegistryLite extensionRegistry) throws IOException {
            CodedInputStream codedInput = CodedInputStream.newInstance(input2);
            this.mergeFrom(codedInput, extensionRegistry);
            codedInput.checkLastTagWas(0);
            return (BuilderType)this;
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream input2, ExtensionRegistryLite extensionRegistry) throws IOException {
            int firstByte = input2.read();
            if (firstByte == -1) {
                return false;
            }
            int size2 = CodedInputStream.readRawVarint32(firstByte, input2);
            LimitedInputStream limitedInput = new LimitedInputStream(input2, size2);
            this.mergeFrom(limitedInput, extensionRegistry);
            return true;
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream input2) throws IOException {
            return this.mergeDelimitedFrom(input2, ExtensionRegistryLite.getEmptyRegistry());
        }

        protected static UninitializedMessageException newUninitializedMessageException(MessageLite message) {
            return new UninitializedMessageException(message);
        }

        protected static <T> void addAll(Iterable<T> values2, Collection<? super T> list) {
            if (values2 instanceof LazyStringList) {
                Builder.checkForNullValues(((LazyStringList)values2).getUnderlyingElements());
            } else {
                Builder.checkForNullValues(values2);
            }
            if (values2 instanceof Collection) {
                Collection collection = (Collection)values2;
                list.addAll(collection);
            } else {
                for (T value2 : values2) {
                    list.add(value2);
                }
            }
        }

        private static void checkForNullValues(Iterable<?> values2) {
            for (Object value2 : values2) {
                if (value2 != null) continue;
                throw new NullPointerException();
            }
        }

        static final class LimitedInputStream
        extends FilterInputStream {
            private int limit;

            LimitedInputStream(InputStream in2, int limit2) {
                super(in2);
                this.limit = limit2;
            }

            public int available() throws IOException {
                return Math.min(super.available(), this.limit);
            }

            public int read() throws IOException {
                if (this.limit <= 0) {
                    return -1;
                }
                int result2 = super.read();
                if (result2 >= 0) {
                    --this.limit;
                }
                return result2;
            }

            public int read(byte[] b, int off, int len2) throws IOException {
                if (this.limit <= 0) {
                    return -1;
                }
                int result2 = super.read(b, off, len2 = Math.min(len2, this.limit));
                if (result2 >= 0) {
                    this.limit -= result2;
                }
                return result2;
            }

            public long skip(long n) throws IOException {
                long result2 = super.skip(Math.min(n, (long)this.limit));
                if (result2 >= 0L) {
                    this.limit = (int)((long)this.limit - result2);
                }
                return result2;
            }
        }
    }
}

