/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.commons.beanutils;

import java.util.Map;
import java.util.WeakHashMap;

public class ContextClassLoaderLocal {
    private Map valueByClassLoader = new WeakHashMap();
    private boolean globalValueInitialized = false;
    private Object globalValue;

    protected Object initialValue() {
        return null;
    }

    public synchronized Object get() {
        this.valueByClassLoader.isEmpty();
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                Object value2 = this.valueByClassLoader.get(contextClassLoader);
                if (value2 == null && !this.valueByClassLoader.containsKey(contextClassLoader)) {
                    value2 = this.initialValue();
                    this.valueByClassLoader.put(contextClassLoader, value2);
                }
                return value2;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!this.globalValueInitialized) {
            this.globalValue = this.initialValue();
            this.globalValueInitialized = true;
        }
        return this.globalValue;
    }

    public synchronized void set(Object value2) {
        this.valueByClassLoader.isEmpty();
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                this.valueByClassLoader.put(contextClassLoader, value2);
                return;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.globalValue = value2;
        this.globalValueInitialized = true;
    }

    public synchronized void unset() {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            this.unset(contextClassLoader);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public synchronized void unset(ClassLoader classLoader) {
        this.valueByClassLoader.remove(classLoader);
    }
}

