/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.cookie;

import com.aliyun.log.thirdparty.org.apache.http.annotation.Immutable;
import com.aliyun.log.thirdparty.org.apache.http.cookie.Cookie;
import com.aliyun.log.thirdparty.org.apache.http.impl.cookie.BasicClientCookie;
import java.util.Comparator;
import java.util.Date;

@Immutable
public class CookiePriorityComparator
implements Comparator<Cookie> {
    public static final CookiePriorityComparator INSTANCE = new CookiePriorityComparator();

    private int getPathLength(Cookie cookie) {
        String path = cookie.getPath();
        return path != null ? path.length() : 1;
    }

    @Override
    public int compare(Cookie c1, Cookie c2) {
        int l1 = this.getPathLength(c1);
        int l2 = this.getPathLength(c2);
        int result2 = l2 - l1;
        if (result2 == 0 && c1 instanceof BasicClientCookie && c2 instanceof BasicClientCookie) {
            Date d1 = ((BasicClientCookie)c1).getCreationDate();
            Date d2 = ((BasicClientCookie)c2).getCreationDate();
            if (d1 != null && d2 != null) {
                return (int)(d1.getTime() - d2.getTime());
            }
        }
        return result2;
    }
}

