/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.impl.client;

import com.alibaba.schedulerx.shade.org.apache.commons.logging.Log;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.LogFactory;
import com.aliyun.log.thirdparty.org.apache.http.HttpHost;
import com.aliyun.log.thirdparty.org.apache.http.HttpRequest;
import com.aliyun.log.thirdparty.org.apache.http.HttpResponse;
import com.aliyun.log.thirdparty.org.apache.http.annotation.ThreadSafe;
import com.aliyun.log.thirdparty.org.apache.http.client.HttpClient;
import com.aliyun.log.thirdparty.org.apache.http.client.ResponseHandler;
import com.aliyun.log.thirdparty.org.apache.http.client.ServiceUnavailableRetryStrategy;
import com.aliyun.log.thirdparty.org.apache.http.client.methods.HttpUriRequest;
import com.aliyun.log.thirdparty.org.apache.http.conn.ClientConnectionManager;
import com.aliyun.log.thirdparty.org.apache.http.impl.client.DefaultHttpClient;
import com.aliyun.log.thirdparty.org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import com.aliyun.log.thirdparty.org.apache.http.params.HttpParams;
import com.aliyun.log.thirdparty.org.apache.http.protocol.HttpContext;
import com.aliyun.log.thirdparty.org.apache.http.util.Args;
import com.aliyun.log.thirdparty.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;

@Deprecated
@ThreadSafe
public class AutoRetryHttpClient
implements HttpClient {
    private final HttpClient backend;
    private final ServiceUnavailableRetryStrategy retryStrategy;
    private final Log log = LogFactory.getLog(this.getClass());

    public AutoRetryHttpClient(HttpClient client, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(client, "HttpClient");
        Args.notNull(retryStrategy, "ServiceUnavailableRetryStrategy");
        this.backend = client;
        this.retryStrategy = retryStrategy;
    }

    public AutoRetryHttpClient() {
        this(new DefaultHttpClient(), new DefaultServiceUnavailableRetryStrategy());
    }

    public AutoRetryHttpClient(ServiceUnavailableRetryStrategy config) {
        this(new DefaultHttpClient(), config);
    }

    public AutoRetryHttpClient(HttpClient client) {
        this(client, new DefaultServiceUnavailableRetryStrategy());
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request2) throws IOException {
        HttpContext defaultContext = null;
        return this.execute(target, request2, defaultContext);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request2, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(target, request2, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request2, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(target, request2, context);
        return responseHandler.handleResponse(resp);
    }

    @Override
    public HttpResponse execute(HttpUriRequest request2) throws IOException {
        HttpContext context = null;
        return this.execute(request2, context);
    }

    @Override
    public HttpResponse execute(HttpUriRequest request2, HttpContext context) throws IOException {
        URI uri = request2.getURI();
        HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        return this.execute(httpHost, (HttpRequest)request2, context);
    }

    @Override
    public <T> T execute(HttpUriRequest request2, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(request2, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpUriRequest request2, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(request2, context);
        return responseHandler.handleResponse(resp);
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request2, HttpContext context) throws IOException {
        int c = 1;
        while (true) {
            block8: {
                HttpResponse response = this.backend.execute(target, request2, context);
                try {
                    if (this.retryStrategy.retryRequest(response, c, context)) {
                        EntityUtils.consume(response.getEntity());
                        long nextInterval = this.retryStrategy.getRetryInterval();
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                            break block8;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                    return response;
                }
                catch (RuntimeException ex) {
                    try {
                        EntityUtils.consume(response.getEntity());
                    }
                    catch (IOException ioex) {
                        this.log.warn("I/O error consuming response content", ioex);
                    }
                    throw ex;
                }
            }
            ++c;
        }
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    @Override
    public HttpParams getParams() {
        return this.backend.getParams();
    }
}

