/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.impl.client;

import com.alibaba.schedulerx.shade.org.apache.commons.logging.Log;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.LogFactory;
import com.aliyun.log.thirdparty.org.apache.http.HttpEntity;
import com.aliyun.log.thirdparty.org.apache.http.HttpHost;
import com.aliyun.log.thirdparty.org.apache.http.HttpRequest;
import com.aliyun.log.thirdparty.org.apache.http.annotation.ThreadSafe;
import com.aliyun.log.thirdparty.org.apache.http.client.ClientProtocolException;
import com.aliyun.log.thirdparty.org.apache.http.client.HttpClient;
import com.aliyun.log.thirdparty.org.apache.http.client.ResponseHandler;
import com.aliyun.log.thirdparty.org.apache.http.client.methods.CloseableHttpResponse;
import com.aliyun.log.thirdparty.org.apache.http.client.methods.HttpUriRequest;
import com.aliyun.log.thirdparty.org.apache.http.client.utils.URIUtils;
import com.aliyun.log.thirdparty.org.apache.http.protocol.HttpContext;
import com.aliyun.log.thirdparty.org.apache.http.util.Args;
import com.aliyun.log.thirdparty.org.apache.http.util.EntityUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;

@ThreadSafe
public abstract class CloseableHttpClient
implements HttpClient,
Closeable {
    private final Log log = LogFactory.getLog(this.getClass());

    protected abstract CloseableHttpResponse doExecute(HttpHost var1, HttpRequest var2, HttpContext var3) throws IOException, ClientProtocolException;

    @Override
    public CloseableHttpResponse execute(HttpHost target, HttpRequest request2, HttpContext context) throws IOException, ClientProtocolException {
        return this.doExecute(target, request2, context);
    }

    @Override
    public CloseableHttpResponse execute(HttpUriRequest request2, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(request2, "HTTP request");
        return this.doExecute(CloseableHttpClient.determineTarget(request2), request2, context);
    }

    private static HttpHost determineTarget(HttpUriRequest request2) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = request2.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }

    @Override
    public CloseableHttpResponse execute(HttpUriRequest request2) throws IOException, ClientProtocolException {
        return this.execute(request2, (HttpContext)null);
    }

    @Override
    public CloseableHttpResponse execute(HttpHost target, HttpRequest request2) throws IOException, ClientProtocolException {
        return this.doExecute(target, request2, null);
    }

    @Override
    public <T> T execute(HttpUriRequest request2, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(request2, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpUriRequest request2, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        HttpHost target = CloseableHttpClient.determineTarget(request2);
        return this.execute(target, request2, responseHandler, context);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request2, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(target, request2, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request2, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(responseHandler, "Response handler");
        CloseableHttpResponse response = this.execute(target, request2, context);
        try {
            T result2 = responseHandler.handleResponse(response);
            HttpEntity entity = response.getEntity();
            EntityUtils.consume(entity);
            T t = result2;
            return t;
        }
        catch (ClientProtocolException t) {
            HttpEntity entity = response.getEntity();
            try {
                EntityUtils.consume(entity);
            }
            catch (Exception t2) {
                this.log.warn("Error consuming content after an exception.", t2);
            }
            throw t;
        }
        finally {
            response.close();
        }
    }
}

