/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.impl.client;

import com.aliyun.log.thirdparty.org.apache.http.HeaderElement;
import com.aliyun.log.thirdparty.org.apache.http.HttpResponse;
import com.aliyun.log.thirdparty.org.apache.http.annotation.Immutable;
import com.aliyun.log.thirdparty.org.apache.http.conn.ConnectionKeepAliveStrategy;
import com.aliyun.log.thirdparty.org.apache.http.message.BasicHeaderElementIterator;
import com.aliyun.log.thirdparty.org.apache.http.protocol.HttpContext;
import com.aliyun.log.thirdparty.org.apache.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param2 = he.getName();
            String value2 = he.getValue();
            if (value2 == null || !param2.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value2) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

